% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_Coexpress}
\alias{module_Coexpress}
\title{module_Coexpress}
\usage{
module_Coexpress(
  ceRExp,
  mRExp = NULL,
  Modulelist,
  resample = 1000,
  method = c("mean", "median"),
  test.method = c("t.test", "wilcox.test")
)
}
\arguments{
\item{ceRExp}{A SummarizedExperiment object. ceRNA expression data: 
rows are samples and columns are ceRNAs.}

\item{mRExp}{NULL (default) or a SummarizedExperiment object. mRNA expression data: 
rows are samples and columns are mRNAs.}

\item{Modulelist}{List object: a list of the identified miRNA sponge modules.}

\item{resample}{The number of random miRNA sponge modules generated, and 1000 times in default.}

\item{method}{The method used to evaluate the co-expression level of each miRNA sponge module.
Users can select "mean" or "median" to calculate co-expression value of each miRNA sponge module
and its corresponding random miRNA sponge module.}

\item{test.method}{The method used to evaluate statistical significance p-value of 
co-expression level higher than random miRNA sponge modules.
Users can select "t.test" or "wilcox.test" to calculate statistical significance p-value of 
co-expression level higher than random miRNA sponge modules.}
}
\value{
List object: co-expression values of miRNA sponge modules and their corresponding random miRNA sponge modules, 
and statistical significance p-value of co-expression level higher than random miRNA sponge modules.
}
\description{
Co-expression analysis of each miRNA sponge module and its corresponding random miRNA sponge modules
}
\examples{
data(BRCASampleData)
modulegenes_WGCNA <- module_WGCNA(ceRExp, mRExp)
# Identify miRNA sponge modules using sensitivity RV coefficient (SRVC)
miRSM_WGCNA_SRVC <- miRSM(miRExp, ceRExp, mRExp, miRTarget,
                        modulegenes_WGCNA, method = "SRVC",
                        SMC.cutoff = 0.01, RV_method = "RV")
miRSM_WGCNA_SRVC_genes <- miRSM_WGCNA_SRVC[[2]]
miRSM_WGCNA_Coexpress <-  module_Coexpress(ceRExp, mRExp, 
                                           miRSM_WGCNA_SRVC_genes, 
                                           resample = 10, method = "mean",
                                           test.method = "t.test")

}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
