% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{miRSM_SS}
\alias{miRSM_SS}
\title{miRSM_SS}
\usage{
miRSM_SS(
  Modulelist.all,
  Modulelist.exceptk,
  sim.cutoff = 0.8,
  sim.method = "Simpson"
)
}
\arguments{
\item{Modulelist.all}{List object, modules using all of samples.}

\item{Modulelist.exceptk}{List object, modules using all of samples excepting sample k.}

\item{sim.cutoff}{Similarity cutoff between modules, the interval is [0 1].}

\item{sim.method}{Methods for calculating similatiry between two modules, select one of three methods (Simpson, Jaccard and Lin). Default method is Simpson.}
}
\value{
A list of sample-specific miRNA sponge modules
}
\description{
Inferring sample-specific miRNA sponge modules
}
\examples{
data(BRCASampleData)
nsamples <- 3
modulegenes_all <- module_igraph(ceRExp[, 151:300], mRExp[, 151:300])
modulegenes_exceptk <- lapply(seq(nsamples), function(i) 
                              module_WGCNA(ceRExp[-i, seq(150)], 
                              mRExp[-i, seq(150)]))
 
miRSM_SRVC_all <- miRSM(miRExp, ceRExp[, 151:300], mRExp[, 151:300], 
                        miRTarget, modulegenes_all, 
                        method = "SRVC", SMC.cutoff = 0.01, 
                        RV_method = "RV")
miRSM_SRVC_exceptk <- lapply(seq(nsamples), function(i) miRSM(miRExp[-i, ], 
                             ceRExp[-i, seq(150)], mRExp[-i, seq(150)], 
                             miRTarget, modulegenes_exceptk[[i]],                                     
                             method = "SRVC",
                             SMC.cutoff = 0.01, RV_method = "RV"))

Modulegenes_all <- miRSM_SRVC_all[[2]]
Modulegenes_exceptk <- lapply(seq(nsamples), function(i) 
                              miRSM_SRVC_exceptk[[i]][[2]])

Modules_SS <- miRSM_SS(Modulegenes_all, Modulegenes_exceptk)

}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
