/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.experiment.SplitEvaluator;

public class ClassifierSplitEvaluator
implements SplitEvaluator,
OptionHandler,
AdditionalMeasureProducer,
RevisionHandler {
    static final long serialVersionUID = -8511241602760467265L;
    protected Classifier m_Template = new ZeroR();
    protected Classifier m_Classifier;
    protected String[] m_AdditionalMeasures = null;
    protected boolean[] m_doesProduce = null;
    protected int m_numberAdditionalMeasures = 0;
    protected String m_result = null;
    protected String m_ClassifierOptions = "";
    protected String m_ClassifierVersion = "";
    private static final int KEY_SIZE = 3;
    private static final int RESULT_SIZE = 30;
    private static final int NUM_IR_STATISTICS = 14;
    private static final int NUM_WEIGHTED_IR_STATISTICS = 8;
    private static final int NUM_UNWEIGHTED_IR_STATISTICS = 2;
    private int m_IRclass = 0;
    private boolean m_predTargetColumn = false;
    private int m_attID = -1;

    public ClassifierSplitEvaluator() {
        this.updateOptions();
    }

    public String globalInfo() {
        return " A SplitEvaluator that produces results for a classification scheme on a nominal class attribute.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tThe full class name of the classifier.\n\teg: weka.classifiers.bayes.NaiveBayes", "W", 1, "-W <class name>"));
        newVector.addElement(new Option("\tThe index of the class for which IR statistics\n\tare to be output. (default 1)", "C", 1, "-C <index>"));
        newVector.addElement(new Option("\tThe index of an attribute to output in the\n\tresults. This attribute should identify an\n\tinstance in order to know which instances are\n\tin the test set of a cross validation. if 0\n\tno output (default 0).", "I", 1, "-I <index>"));
        newVector.addElement(new Option("\tAdd target and prediction columns to the result\n\tfor each fold.", "P", 0, "-P"));
        if (this.m_Template != null && this.m_Template instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Template.getClass().getName() + ":"));
            Enumeration enu = ((OptionHandler)((Object)this.m_Template)).listOptions();
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String indexName;
        String cName = Utils.getOption('W', options);
        if (cName.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        this.setClassifier(AbstractClassifier.forName(cName, null));
        if (this.getClassifier() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getClassifier())).setOptions(Utils.partitionOptions(options));
            this.updateOptions();
        }
        this.m_IRclass = (indexName = Utils.getOption('C', options)).length() != 0 ? new Integer(indexName) - 1 : 0;
        String attID = Utils.getOption('I', options);
        this.m_attID = attID.length() != 0 ? new Integer(attID) - 1 : -1;
        this.m_predTargetColumn = Utils.getFlag('P', options);
    }

    @Override
    public String[] getOptions() {
        String[] classifierOptions = new String[]{};
        if (this.m_Template != null && this.m_Template instanceof OptionHandler) {
            classifierOptions = ((OptionHandler)((Object)this.m_Template)).getOptions();
        }
        String[] options = new String[classifierOptions.length + 8];
        int current = 0;
        if (this.getClassifier() != null) {
            options[current++] = "-W";
            options[current++] = this.getClassifier().getClass().getName();
        }
        options[current++] = "-I";
        options[current++] = "" + (this.m_attID + 1);
        if (this.getPredTargetColumn()) {
            options[current++] = "-P";
        }
        options[current++] = "-C";
        options[current++] = "" + (this.m_IRclass + 1);
        options[current++] = "--";
        System.arraycopy(classifierOptions, 0, options, current, classifierOptions.length);
        current += classifierOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public void setAdditionalMeasures(String[] additionalMeasures) {
        this.m_AdditionalMeasures = additionalMeasures;
        if (this.m_AdditionalMeasures != null && this.m_AdditionalMeasures.length > 0) {
            this.m_doesProduce = new boolean[this.m_AdditionalMeasures.length];
            if (this.m_Template instanceof AdditionalMeasureProducer) {
                Enumeration en = ((AdditionalMeasureProducer)((Object)this.m_Template)).enumerateMeasures();
                while (en.hasMoreElements()) {
                    String mname = (String)en.nextElement();
                    for (int j = 0; j < this.m_AdditionalMeasures.length; ++j) {
                        if (mname.compareToIgnoreCase(this.m_AdditionalMeasures[j]) != 0) continue;
                        this.m_doesProduce[j] = true;
                    }
                }
            }
        } else {
            this.m_doesProduce = null;
        }
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        if (this.m_Template instanceof AdditionalMeasureProducer) {
            Enumeration en = ((AdditionalMeasureProducer)((Object)this.m_Template)).enumerateMeasures();
            while (en.hasMoreElements()) {
                String mname = (String)en.nextElement();
                newVector.addElement(mname);
            }
        }
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (this.m_Template instanceof AdditionalMeasureProducer) {
            if (this.m_Classifier == null) {
                throw new IllegalArgumentException("ClassifierSplitEvaluator: Can't return result for measure, classifier has not been built yet.");
            }
            return ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException("ClassifierSplitEvaluator: Can't return value for : " + additionalMeasureName + ". " + this.m_Template.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    @Override
    public Object[] getKeyTypes() {
        Object[] keyTypes = new Object[]{"", "", ""};
        return keyTypes;
    }

    @Override
    public String[] getKeyNames() {
        String[] keyNames = new String[]{"Scheme", "Scheme_options", "Scheme_version_ID"};
        return keyNames;
    }

    @Override
    public Object[] getKey() {
        Object[] key = new Object[]{this.m_Template.getClass().getName(), this.m_ClassifierOptions, this.m_ClassifierVersion};
        return key;
    }

    @Override
    public Object[] getResultTypes() {
        int addm = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        int overall_length = 30 + addm;
        overall_length += 14;
        overall_length += 8;
        overall_length += 2;
        if (this.getAttributeID() >= 0) {
            ++overall_length;
        }
        if (this.getPredTargetColumn()) {
            overall_length += 2;
        }
        Object[] resultTypes = new Object[overall_length];
        Double doub = new Double(0.0);
        int current = 0;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        if (this.getAttributeID() >= 0) {
            resultTypes[current++] = "";
        }
        if (this.getPredTargetColumn()) {
            resultTypes[current++] = "";
            resultTypes[current++] = "";
        }
        resultTypes[current++] = "";
        for (int i = 0; i < addm; ++i) {
            resultTypes[current++] = doub;
        }
        if (current != overall_length) {
            throw new Error("ResultTypes didn't fit RESULT_SIZE");
        }
        return resultTypes;
    }

    @Override
    public String[] getResultNames() {
        int addm = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        int overall_length = 30 + addm;
        overall_length += 14;
        overall_length += 8;
        overall_length += 2;
        if (this.getAttributeID() >= 0) {
            ++overall_length;
        }
        if (this.getPredTargetColumn()) {
            overall_length += 2;
        }
        String[] resultNames = new String[overall_length];
        int current = 0;
        resultNames[current++] = "Number_of_training_instances";
        resultNames[current++] = "Number_of_testing_instances";
        resultNames[current++] = "Number_correct";
        resultNames[current++] = "Number_incorrect";
        resultNames[current++] = "Number_unclassified";
        resultNames[current++] = "Percent_correct";
        resultNames[current++] = "Percent_incorrect";
        resultNames[current++] = "Percent_unclassified";
        resultNames[current++] = "Kappa_statistic";
        resultNames[current++] = "Mean_absolute_error";
        resultNames[current++] = "Root_mean_squared_error";
        resultNames[current++] = "Relative_absolute_error";
        resultNames[current++] = "Root_relative_squared_error";
        resultNames[current++] = "SF_prior_entropy";
        resultNames[current++] = "SF_scheme_entropy";
        resultNames[current++] = "SF_entropy_gain";
        resultNames[current++] = "SF_mean_prior_entropy";
        resultNames[current++] = "SF_mean_scheme_entropy";
        resultNames[current++] = "SF_mean_entropy_gain";
        resultNames[current++] = "KB_information";
        resultNames[current++] = "KB_mean_information";
        resultNames[current++] = "KB_relative_information";
        resultNames[current++] = "True_positive_rate";
        resultNames[current++] = "Num_true_positives";
        resultNames[current++] = "False_positive_rate";
        resultNames[current++] = "Num_false_positives";
        resultNames[current++] = "True_negative_rate";
        resultNames[current++] = "Num_true_negatives";
        resultNames[current++] = "False_negative_rate";
        resultNames[current++] = "Num_false_negatives";
        resultNames[current++] = "IR_precision";
        resultNames[current++] = "IR_recall";
        resultNames[current++] = "F_measure";
        resultNames[current++] = "Area_under_ROC";
        resultNames[current++] = "Weighted_avg_true_positive_rate";
        resultNames[current++] = "Weighted_avg_false_positive_rate";
        resultNames[current++] = "Weighted_avg_true_negative_rate";
        resultNames[current++] = "Weighted_avg_false_negative_rate";
        resultNames[current++] = "Weighted_avg_IR_precision";
        resultNames[current++] = "Weighted_avg_IR_recall";
        resultNames[current++] = "Weighted_avg_F_measure";
        resultNames[current++] = "Weighted_avg_area_under_ROC";
        resultNames[current++] = "Unweighted_macro_avg_F_measure";
        resultNames[current++] = "Unweighted_micro_avg_F_measure";
        resultNames[current++] = "Elapsed_Time_training";
        resultNames[current++] = "Elapsed_Time_testing";
        resultNames[current++] = "UserCPU_Time_training";
        resultNames[current++] = "UserCPU_Time_testing";
        resultNames[current++] = "Serialized_Model_Size";
        resultNames[current++] = "Serialized_Train_Set_Size";
        resultNames[current++] = "Serialized_Test_Set_Size";
        resultNames[current++] = "Coverage_of_Test_Cases_By_Regions";
        resultNames[current++] = "Size_of_Predicted_Regions";
        if (this.getAttributeID() >= 0) {
            resultNames[current++] = "Instance_ID";
        }
        if (this.getPredTargetColumn()) {
            resultNames[current++] = "Targets";
            resultNames[current++] = "Predictions";
        }
        resultNames[current++] = "Summary";
        for (int i = 0; i < addm; ++i) {
            resultNames[current++] = this.m_AdditionalMeasures[i];
        }
        if (current != overall_length) {
            throw new Error("ResultNames didn't fit RESULT_SIZE");
        }
        return resultNames;
    }

    @Override
    public Object[] getResult(Instances train, Instances test) throws Exception {
        int i;
        ThreadMXBean thMonitor;
        boolean canMeasureCPUTime;
        if (train.classAttribute().type() != 1) {
            throw new Exception("Class attribute is not nominal!");
        }
        if (this.m_Template == null) {
            throw new Exception("No classifier has been specified");
        }
        int addm = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        int overall_length = 30 + addm;
        overall_length += 14;
        overall_length += 8;
        overall_length += 2;
        if (this.getAttributeID() >= 0) {
            ++overall_length;
        }
        if (this.getPredTargetColumn()) {
            overall_length += 2;
        }
        if ((canMeasureCPUTime = (thMonitor = ManagementFactory.getThreadMXBean()).isThreadCpuTimeSupported()) && !thMonitor.isThreadCpuTimeEnabled()) {
            thMonitor.setThreadCpuTimeEnabled(true);
        }
        Object[] result = new Object[overall_length];
        Evaluation eval = new Evaluation(train);
        this.m_Classifier = AbstractClassifier.makeCopy(this.m_Template);
        long thID = Thread.currentThread().getId();
        long CPUStartTime = -1L;
        long trainCPUTimeElapsed = -1L;
        long testCPUTimeElapsed = -1L;
        long trainTimeStart = System.currentTimeMillis();
        if (canMeasureCPUTime) {
            CPUStartTime = thMonitor.getThreadUserTime(thID);
        }
        this.m_Classifier.buildClassifier(train);
        if (canMeasureCPUTime) {
            trainCPUTimeElapsed = thMonitor.getThreadUserTime(thID) - CPUStartTime;
        }
        long trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
        long testTimeStart = System.currentTimeMillis();
        if (canMeasureCPUTime) {
            CPUStartTime = thMonitor.getThreadUserTime(thID);
        }
        double[] predictions = eval.evaluateModel(this.m_Classifier, test, new Object[0]);
        if (canMeasureCPUTime) {
            testCPUTimeElapsed = thMonitor.getThreadUserTime(thID) - CPUStartTime;
        }
        long testTimeElapsed = System.currentTimeMillis() - testTimeStart;
        thMonitor = null;
        this.m_result = eval.toSummaryString();
        int current = 0;
        result[current++] = new Double(train.numInstances());
        result[current++] = new Double(eval.numInstances());
        result[current++] = new Double(eval.correct());
        result[current++] = new Double(eval.incorrect());
        result[current++] = new Double(eval.unclassified());
        result[current++] = new Double(eval.pctCorrect());
        result[current++] = new Double(eval.pctIncorrect());
        result[current++] = new Double(eval.pctUnclassified());
        result[current++] = new Double(eval.kappa());
        result[current++] = new Double(eval.meanAbsoluteError());
        result[current++] = new Double(eval.rootMeanSquaredError());
        result[current++] = new Double(eval.relativeAbsoluteError());
        result[current++] = new Double(eval.rootRelativeSquaredError());
        result[current++] = new Double(eval.SFPriorEntropy());
        result[current++] = new Double(eval.SFSchemeEntropy());
        result[current++] = new Double(eval.SFEntropyGain());
        result[current++] = new Double(eval.SFMeanPriorEntropy());
        result[current++] = new Double(eval.SFMeanSchemeEntropy());
        result[current++] = new Double(eval.SFMeanEntropyGain());
        result[current++] = new Double(eval.KBInformation());
        result[current++] = new Double(eval.KBMeanInformation());
        result[current++] = new Double(eval.KBRelativeInformation());
        result[current++] = new Double(eval.truePositiveRate(this.m_IRclass));
        result[current++] = new Double(eval.numTruePositives(this.m_IRclass));
        result[current++] = new Double(eval.falsePositiveRate(this.m_IRclass));
        result[current++] = new Double(eval.numFalsePositives(this.m_IRclass));
        result[current++] = new Double(eval.trueNegativeRate(this.m_IRclass));
        result[current++] = new Double(eval.numTrueNegatives(this.m_IRclass));
        result[current++] = new Double(eval.falseNegativeRate(this.m_IRclass));
        result[current++] = new Double(eval.numFalseNegatives(this.m_IRclass));
        result[current++] = new Double(eval.precision(this.m_IRclass));
        result[current++] = new Double(eval.recall(this.m_IRclass));
        result[current++] = new Double(eval.fMeasure(this.m_IRclass));
        result[current++] = new Double(eval.areaUnderROC(this.m_IRclass));
        result[current++] = new Double(eval.weightedTruePositiveRate());
        result[current++] = new Double(eval.weightedFalsePositiveRate());
        result[current++] = new Double(eval.weightedTrueNegativeRate());
        result[current++] = new Double(eval.weightedFalseNegativeRate());
        result[current++] = new Double(eval.weightedPrecision());
        result[current++] = new Double(eval.weightedRecall());
        result[current++] = new Double(eval.weightedFMeasure());
        result[current++] = new Double(eval.weightedAreaUnderROC());
        result[current++] = new Double(eval.unweightedMacroFmeasure());
        result[current++] = new Double(eval.unweightedMicroFmeasure());
        result[current++] = new Double((double)trainTimeElapsed / 1000.0);
        result[current++] = new Double((double)testTimeElapsed / 1000.0);
        if (canMeasureCPUTime) {
            result[current++] = new Double((double)trainCPUTimeElapsed / 1000000.0 / 1000.0);
            result[current++] = new Double((double)testCPUTimeElapsed / 1000000.0 / 1000.0);
        } else {
            result[current++] = new Double(Utils.missingValue());
            result[current++] = new Double(Utils.missingValue());
        }
        ByteArrayOutputStream bastream = new ByteArrayOutputStream();
        ObjectOutputStream oostream = new ObjectOutputStream(bastream);
        oostream.writeObject(this.m_Classifier);
        result[current++] = new Double(bastream.size());
        bastream = new ByteArrayOutputStream();
        oostream = new ObjectOutputStream(bastream);
        oostream.writeObject(train);
        result[current++] = new Double(bastream.size());
        bastream = new ByteArrayOutputStream();
        oostream = new ObjectOutputStream(bastream);
        oostream.writeObject(test);
        result[current++] = new Double(bastream.size());
        result[current++] = new Double(eval.coverageOfTestCasesByPredictedRegions());
        result[current++] = new Double(eval.sizeOfPredictedRegions());
        if (this.getAttributeID() >= 0) {
            String idsString = "";
            if (test.attribute(this.m_attID).isNumeric()) {
                if (test.numInstances() > 0) {
                    idsString = idsString + test.instance(0).value(this.m_attID);
                }
                for (i = 1; i < test.numInstances(); ++i) {
                    idsString = idsString + "|" + test.instance(i).value(this.m_attID);
                }
            } else {
                if (test.numInstances() > 0) {
                    idsString = idsString + test.instance(0).stringValue(this.m_attID);
                }
                for (i = 1; i < test.numInstances(); ++i) {
                    idsString = idsString + "|" + test.instance(i).stringValue(this.m_attID);
                }
            }
            result[current++] = idsString;
        }
        if (this.getPredTargetColumn()) {
            String predictionsString;
            String targetsString;
            if (test.classAttribute().isNumeric()) {
                if (test.numInstances() > 0) {
                    targetsString = "";
                    targetsString = targetsString + test.instance(0).value(test.classIndex());
                    for (i = 1; i < test.numInstances(); ++i) {
                        targetsString = targetsString + "|" + test.instance(i).value(test.classIndex());
                    }
                    result[current++] = targetsString;
                }
                if (predictions.length > 0) {
                    predictionsString = "";
                    predictionsString = predictionsString + predictions[0];
                    for (i = 1; i < predictions.length; ++i) {
                        predictionsString = predictionsString + "|" + predictions[i];
                    }
                    result[current++] = predictionsString;
                }
            } else {
                if (test.numInstances() > 0) {
                    targetsString = "";
                    targetsString = targetsString + test.instance(0).stringValue(test.classIndex());
                    for (i = 1; i < test.numInstances(); ++i) {
                        targetsString = targetsString + "|" + test.instance(i).stringValue(test.classIndex());
                    }
                    result[current++] = targetsString;
                }
                if (predictions.length > 0) {
                    predictionsString = "";
                    predictionsString = predictionsString + test.classAttribute().value((int)predictions[0]);
                    for (i = 1; i < predictions.length; ++i) {
                        predictionsString = predictionsString + "|" + test.classAttribute().value((int)predictions[i]);
                    }
                    result[current++] = predictionsString;
                }
            }
        }
        result[current++] = this.m_Classifier instanceof Summarizable ? ((Summarizable)((Object)this.m_Classifier)).toSummaryString() : null;
        for (int i2 = 0; i2 < addm; ++i2) {
            if (this.m_doesProduce[i2]) {
                try {
                    double dv = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i2]);
                    if (!Utils.isMissingValue(dv)) {
                        Double value = new Double(dv);
                        result[current++] = value;
                        continue;
                    }
                    result[current++] = null;
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                continue;
            }
            result[current++] = null;
        }
        if (current != overall_length) {
            throw new Error("Results didn't fit RESULT_SIZE");
        }
        return result;
    }

    public String classifierTipText() {
        return "The classifier to use.";
    }

    public Classifier getClassifier() {
        return this.m_Template;
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_Template = newClassifier;
        this.updateOptions();
    }

    public int getClassForIRStatistics() {
        return this.m_IRclass;
    }

    public void setClassForIRStatistics(int v) {
        this.m_IRclass = v;
    }

    public int getAttributeID() {
        return this.m_attID;
    }

    public void setAttributeID(int v) {
        this.m_attID = v;
    }

    public boolean getPredTargetColumn() {
        return this.m_predTargetColumn;
    }

    public void setPredTargetColumn(boolean v) {
        this.m_predTargetColumn = v;
    }

    protected void updateOptions() {
        this.m_ClassifierOptions = this.m_Template instanceof OptionHandler ? Utils.joinOptions(((OptionHandler)((Object)this.m_Template)).getOptions()) : "";
        if (this.m_Template instanceof Serializable) {
            ObjectStreamClass obs = ObjectStreamClass.lookup(this.m_Template.getClass());
            this.m_ClassifierVersion = "" + obs.getSerialVersionUID();
        } else {
            this.m_ClassifierVersion = "";
        }
    }

    public void setClassifierName(String newClassifierName) throws Exception {
        try {
            this.setClassifier((Classifier)Class.forName(newClassifierName).newInstance());
        }
        catch (Exception ex) {
            throw new Exception("Can't find Classifier with class name: " + newClassifierName);
        }
    }

    @Override
    public String getRawResultOutput() {
        StringBuffer result = new StringBuffer();
        if (this.m_Classifier == null) {
            return "<null> classifier";
        }
        result.append(this.toString());
        result.append("Classifier model: \n" + this.m_Classifier.toString() + '\n');
        if (this.m_result != null) {
            result.append(this.m_result);
            if (this.m_doesProduce != null) {
                for (int i = 0; i < this.m_doesProduce.length; ++i) {
                    if (!this.m_doesProduce[i]) continue;
                    try {
                        double dv = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i]);
                        if (!Utils.isMissingValue(dv)) {
                            Double value = new Double(dv);
                            result.append(this.m_AdditionalMeasures[i] + " : " + value + '\n');
                            continue;
                        }
                        result.append(this.m_AdditionalMeasures[i] + " : " + '?' + '\n');
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                }
            }
        }
        return result.toString();
    }

    public String toString() {
        String result = "ClassifierSplitEvaluator: ";
        if (this.m_Template == null) {
            return result + "<null> classifier";
        }
        return result + this.m_Template.getClass().getName() + " " + this.m_ClassifierOptions + "(version " + this.m_ClassifierVersion + ")";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7511 $");
    }
}

