% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiRNANameConverter.R
\docType{methods}
\name{assessVersion}
\alias{assessVersion}
\alias{assessVersion,MiRNANameConverter-method}
\title{Assess miRBase version}
\usage{
assessVersion(this, miRNAs, verbose = FALSE)

\S4method{assessVersion}{MiRNANameConverter}(this, miRNAs, verbose = FALSE)
}
\arguments{
\item{this}{Object of class 'MiRNANameConverter'}

\item{miRNAs}{A character vector of miRNA names}

\item{verbose}{A boolean to either show more (TRUE) or less information (FALSE)}
}
\value{
A data frame with two columns: version and frequency (decreasing
order by frequency, version)
				+ version: miRBase version
				+ frequency: the number of valid miRNAs that could be assigned
				to the version respectively
}
\description{
This function detects the most likely miRBase version of a
given miRNA set.
Assess miRBase version

This function detects the most likely miRBase version of a given miRNA set.
}
\details{
This function takes a set of miRNA names and detects the most likely miRBase
version of this given set of 'miRNAs'. First all miRNAs will be checked for
validity (if they are actual miRNA names \code{checkMiRNAName} and the set
that passes the check will be further processed.
}
\section{Methods (by class)}{
\itemize{
\item \code{MiRNANameConverter}: Method for assessing the most likely miRBase
version that a given set of miRNA names is from.
}}

\examples{
nc = MiRNANameConverter(); # Instance of class 'MiRNANameConverter'
assessVersion(nc, miRNAs = c("hsa-miR-140", "hsa-miR-125a"))

}
\author{
Stefan Haunsberger
}
