% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRBaseConvert.R
\name{miRNA_NameToAccession}
\alias{miRNA_NameToAccession}
\title{The miRBase miRNA names with specified version to Accessions}
\usage{
miRNA_NameToAccession(miRNANames, version = "v22")
}
\arguments{
\item{miRNANames}{A character vector representing the source miRNA names needed to be convert.}

\item{version}{A character value representing the version corresponding the miRNANames.
Users can apply the function \strong{getAllVersionInfo()} to get the available miRNA version names.
The optional values are in below:\cr
"v6","v7_1","v8","v8_1","v8_2","v9","v9_1","v9_2","v10","v10_1","v11","v12","v13","v14",\cr
"v15","v16","v17","v18","v19","v20","v21","v22"\cr}
}
\value{
A nx2 data frame. The number of rows equal to the input miRNA names. The two columns are defined as below:

\itemize{
 \item \strong{miRNAName_\{Version\}} : The input miRNA names (Column 1).\cr
 \item \strong{Accession} : The convert Accession(Column 2).\cr
 }
}
\description{
This function converts a group of any species' miRNA name to the Accessions defined in miRBase.
}
\examples{
data(miRNATest)
miRNANames=miRNATest$miRNA_Name
version=checkMiRNAVersion(miRNANames,verbose=TRUE)
result1=miRNA_NameToAccession(miRNANames,version=version)
result2=miRNA_AccessionToName(result1[,2],targetVersion="v22")
result3=miRNAVersionConvert(miRNANames,targetVersion="v22",exact=TRUE)

}
\author{
Xu, Taosheng \email{taosheng.x@gmail.com}
}
