% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRBaseConvert.R
\name{getMiRNASequence}
\alias{getMiRNASequence}
\title{Get the miRNA sequences}
\usage{
getMiRNASequence(Accessions, targetVersion = "v22")
}
\arguments{
\item{Accessions}{A character vector representing the miRNA Accessions in miRBase.}

\item{targetVersion}{A character value representing the target miRBase version corresponding the Accessions.
 Users can apply the function \strong{getAllVersionInfo()} to get the available miRNA version names.
The optional values are in below:\cr
"v6","v7_1","v8","v8_1","v8_2","v9","v9_1","v9_2","v10","v10_1","v11","v12","v13","v14",\cr
"v15","v16","v17","v18","v19","v20","v21","v22"\cr}
}
\value{
A nx2 data frame. The number of row equals to input miRNAs. The two columns are defined as below:

\itemize{
 \item \strong{Accession} : The original miRNA (Column 1).\cr
 \item \strong{miRNASequence_\{targetVersion\}} : The return miRNA sequence (in specified version) corresponding to the input miRNAs (Column 2).\cr
 }
}
\description{
This function returns the miRNA sequences for a list of miRNAs.
}
\examples{
#####1, The input are miRNA Accessions
data(miRNATest)
Accessions=miRNATest$Accession
result1=getMiRNASequence(Accessions,targetVersion="v13")
result2=getMiRNASequence(Accessions,targetVersion="v22")

#####2, The input are miRNA Names
data(miRNATest)
miRNANames=miRNATest$miRNA_Name
result3=miRNAVersionConvert(miRNANames,targetVersion="v22",exact=TRUE)
Accessions=result3$Accession
result4=getMiRNASequence(Accessions,targetVersion="v22")

}
\author{
Xu, Taosheng \email{taosheng.x@gmail.com}
}
