% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRBaseConvert.R
\name{checkMiRNAFamily}
\alias{checkMiRNAFamily}
\title{Check the miRNA family}
\usage{
checkMiRNAFamily(Accessions)
}
\arguments{
\item{Accessions}{A character vector representing the miRNA Accessions in miRBase.}
}
\value{
A data frame with four columns. The number of rows equal to the input Accessions. The four columns are defined as below:
\itemize{
 \item  \strong{Accession} : The input miRNA accessions.\cr
 \item \strong{miRNAName_v21} : The miRNA names (version 21) corresponding to the Accession.\cr
 \item \strong{FamilyAccession} : The accession of the family .\cr
 \item \strong{Family} : The family name.\cr
}
}
\description{
This function checks the miRNA family for a list of miRNA Names.
}
\examples{
data(miRNATest)
## The input is miRNA Accessions
Accessions=miRNATest$Accession
Family_Info1=checkMiRNAFamily(Accessions)

##The input is miRNA names
miRNANames=miRNATest$miRNA_Name
version=checkMiRNAVersion(miRNANames,verbose = TRUE)
result=miRNA_NameToAccession(miRNANames,version=version)
Accessions=result$Accession
Family_Info2=checkMiRNAFamily(Accessions)

}
\author{
Xu, Taosheng \email{taosheng.x@gmail.com}
}
