% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterCells.R
\name{filterCells}
\alias{filterCells}
\title{filterCells}
\usage{
filterCells(
sce,
model = NULL,
posterior_cutoff = 0.75,
keep_all_below_boundary = TRUE,
enforce_left_cutoff = TRUE,
verbose = TRUE
)
}
\arguments{
\item{sce}{(SingleCellExperiment) Input data object.}

\item{model}{(flexmix) Output of mixtureModel function, which should be
explicitly called first to ensure stability of model parameters.
Default = NULL.}

\item{posterior_cutoff}{(numeric) The posterior probability of a cell being
part of the compromised distribution, a number between 0 and 1. Any cells
below the appointed cutoff will be marked to keep.
Default = 0.75}

\item{keep_all_below_boundary}{(boolean) Ensures that no cells below the
intact cell distribution are removed. This should almost always be set
to true.
Default = TRUE}

\item{enforce_left_cutoff}{(boolean) Prevents a U-shape in the filtering 
plot. Identifies the cell with the lowest mitochondrial fraction that is
set to be discarded, it ensures that no cells with lower library 
complexity (further left) and higher mitochondrial percentage (further up)
than it are kept.
Default = TRUE}

\item{verbose}{(boolean) Whether to report how many cells (columns) are being
removed from the SingleCellExperiment object.
Default = TRUE}
}
\value{
Returns a SingleCellExperiment object, the same as the input except
with a new column in colData, prob_compromised, and all cells with greater
than the set posterior probability removed from the dataset.
}
\description{
Find those cells probabilistically determined to be compromised by the
mixture model and remove them from the dataset.
}
\examples{
library(scRNAseq)
library(scater)
sce <- ZeiselBrainData()
mt_genes <- grepl("^mt-",  rownames(sce))
feature_ctrls <- list(mito = rownames(sce)[mt_genes])
sce <- addPerCellQC(sce, subsets = feature_ctrls)
model <- mixtureModel(sce)
sce <- filterCells(sce, model)
}
