% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R, R/methylDBFunctions.R
\docType{methods}
\name{pool}
\alias{pool}
\alias{pool,methylBase-method}
\alias{pool,methylBaseDB-method}
\title{Pool replicates within groups to a single sample per group}
\usage{
pool(obj, sample.ids, chunk.size = 1e+06, save.db = FALSE, ...)

\S4method{pool}{methylBase}(obj, sample.ids, chunk.size = 1e+06, save.db = FALSE, ...)

\S4method{pool}{methylBaseDB}(obj, sample.ids, chunk.size = 1e+06, save.db = TRUE, ...)
}
\arguments{
\item{obj}{\link{methylBase} or \link{methylBaseDB} object with two groups
 or more and each group 
should have multiple samples}

\item{sample.ids}{a character vector of new sample.ids ex:c("test","control"), 
 should follow the same order as unique treatment vector,
and should be equal to the length of the unique treatment
 vector}

\item{chunk.size}{Number of rows to be taken as a chunk for processing the 
\code{methylRawListDB} objects, default: 1e6}

\item{save.db}{A Logical to decide whether the resulting object should be 
saved as flat file database or not, default: explained in Details sections}

\item{...}{optional Arguments used when save.db is TRUE

\code{suffix}
      A character string to append to the name of the
       output flat file database, 
      only used if save.db is true, default actions: 
      The default suffix is a 13-character random string appended 
      to the fixed prefix \dQuote{methylBase}, e.g. 
      \dQuote{methylBase_16d3047c1a254.txt.bgz}. 
      
\code{dbdir} 
      The directory where flat file database(s) should be 
      stored, defaults
      to getwd(), working directory for newly stored databases
      and to same directory for already existing database
      
\code{dbtype}
       The type of the flat file database, currently only option is "tabix"
       (only used for newly stored databases)}
}
\value{
a  \link{methylBase} or \link{methylBaseDB} object depending 
on class of input object
}
\description{
The function sums up coverage, numCs and numTs values within each group so 
one representative sample for each group will be created in a new methylBase
 object
}
\section{Details}{

The parameter \code{chunk.size} is only used when working with 
\code{methylBaseDB} objects, 
as they are read in chunk by chunk to enable processing large-sized 
objects which are stored as flat file database.
Per default the chunk.size is set to 1M rows, which should work for 
most systems. If you encounter memory problems or 
have a high amount of memory available feel free to adjust the 
\code{chunk.size}.

The parameter \code{save.db} is per default TRUE for methylDB objects as 
\code{methylBaseDB}, 
while being per default FALSE for \code{methylBase}. If you wish to save 
the result of an 
in-memory-calculation as flat file database or if the size of the 
database allows the calculation in-memory, 
then you might want to change the value of this parameter.
}

\examples{

data(methylKit)

# methylBase.obj has two groups, each group has two samples,
# the following function will pool the samples in each group
# so that each group will be represented by one pooled sample
pooled.methylBase=pool(methylBase.obj,sample.ids=c("test","control"))

}
\author{
Altuna Akalin
}
