% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R, R/diffMeth.R, R/methylDBClasses.R
\docType{methods}
\name{getSampleID}
\alias{getSampleID}
\alias{getSampleID<-}
\alias{getSampleID,methylRawList-method}
\alias{getSampleID<-,methylRawList-method}
\alias{getSampleID,methylBase-method}
\alias{getSampleID<-,methylBase-method}
\alias{getSampleID,methylRaw-method}
\alias{getSampleID<-,methylRaw-method}
\alias{getSampleID,methylDiff-method}
\alias{getSampleID<-,methylDiff-method}
\alias{getSampleID,methylRawListDB-method}
\alias{getSampleID<-,methylRawListDB-method}
\alias{getSampleID,methylBaseDB-method}
\alias{getSampleID<-,methylBaseDB-method}
\alias{getSampleID,methylRawDB-method}
\alias{getSampleID<-,methylRawDB-method}
\alias{getSampleID,methylDiffDB-method}
\alias{getSampleID<-,methylDiffDB-method}
\title{Get or Set Sample-IDs of the methylKit objects}
\usage{
getSampleID(x)
getSampleID(x) <- value

getSampleID(x) <- value

\S4method{getSampleID}{methylRawList}(x)

\S4method{getSampleID}{methylRawList}(x) <- value

\S4method{getSampleID}{methylBase}(x)

\S4method{getSampleID}{methylBase}(x) <- value

\S4method{getSampleID}{methylRaw}(x)

\S4method{getSampleID}{methylRaw}(x) <- value

\S4method{getSampleID}{methylDiff}(x)

\S4method{getSampleID}{methylDiff}(x) <- value

\S4method{getSampleID}{methylRawListDB}(x)

\S4method{getSampleID}{methylRawListDB}(x) <- value

\S4method{getSampleID}{methylBaseDB}(x)

\S4method{getSampleID}{methylBaseDB}(x) <- value

\S4method{getSampleID}{methylRawDB}(x)

\S4method{getSampleID}{methylRawDB}(x) <- value

\S4method{getSampleID}{methylDiffDB}(x)

\S4method{getSampleID}{methylDiffDB}(x) <- value
}
\arguments{
\item{x}{an \code{\link{methylBaseDB}},\code{\link{methylRawListDB}} or 
\code{\link{methylDiffDB}} object}

\item{value}{a valid replacement vector for the sample-ids of the object}
}
\description{
The function returns or replaces the sample-ids stored in any of the 
following \code{methylKit} objects:
\code{\link{methylRaw}}, \code{\link{methylRawDB}}, \code{\link{methylBase}}, 
\code{\link{methylBaseDB}},
\code{\link{methylRawList}}, \code{\link{methylRawListDB}}, 
\code{\link{methylDiff}}, \code{\link{methylDiffDB}}.
}
\examples{

data(methylKit)

#The Sample-Ids can be printed ..
getSampleID(methylBase.obj)

# .. or replaced. 
newObj <- methylBase.obj
getSampleID(newObj) <- c("sample1","sample2","sample3","sample4")
getSampleID(newObj)


}
