% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R, R/diffMeth.R, R/methylDBClasses.R
\docType{methods}
\name{getContext}
\alias{getContext}
\alias{getContext,methylBase-method}
\alias{getContext,methylRaw-method}
\alias{getContext,methylDiff-method}
\alias{getContext,methylRawDB-method}
\alias{getContext,methylBaseDB-method}
\alias{getContext,methylDiffDB-method}
\title{get the context of methylation}
\usage{
getContext(x)

\S4method{getContext}{methylBase}(x)

\S4method{getContext}{methylRaw}(x)

\S4method{getContext}{methylDiff}(x)

\S4method{getContext}{methylRawDB}(x)

\S4method{getContext}{methylBaseDB}(x)

\S4method{getContext}{methylDiffDB}(x)
}
\arguments{
\item{x}{an \code{\link{methylBase}},\code{\link{methylBaseDB}},
\code{\link{methylRaw}},\code{\link{methylRawDB}} or an 
\code{\link{methylDiff}} object}
}
\value{
a string for the context methylation
}
\description{
The function returns the context of methylation. For example: "CpG","CHH" or "CHG"
}
\examples{

data(methylKit)

getContext(methylBase.obj)
getContext(methylDiff.obj)
getContext(methylRawList.obj[[1]])

}
