% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylRRA.R
\name{methylRRA}
\alias{methylRRA}
\title{Enrichment analysis after adjusting multiple p-values of
each gene by Robust Rank Aggregation}
\usage{
methylRRA(cpg.pval, array.type = "450K", FullAnnot = NULL,
  group = "all", method = "ORA", sig.cut = 0.05, topDE = NULL,
  GS.list = NULL, GS.idtype = "SYMBOL", GS.type = "GO",
  minsize = 100, maxsize = 500)
}
\arguments{
\item{cpg.pval}{A named vector containing p-values of differential
methylation test. Names should be CpG IDs.}

\item{array.type}{A string. Either "450K" or "EPIC". Default is "450K".
This argument will be ignored if FullAnnot is provided.}

\item{FullAnnot}{A data frame provided by prepareAnnot function.
Default is NULL.}

\item{group}{A string. "all", "body", "promoter1" or "promoter2". 
Default is "all". If group = "body", only CpGs on gene body will be 
considered in methylRRA. If group = "promoter1" or group = "promoter2", 
only CpGs on promoters will be considered. Here is the definition of "body", 
"promoter1" and "promoter2" according to the annotation in 
IlluminaHumanMethylation450kanno.ilmn12.hg19 or 
IlluminaHumanMethylationEPICanno.ilm10b4.hg19. 
\itemize{
  \item body: CpGs whose gene group correspond to "Body" or "1stExon" 
  \item promoter1: CpGs whose gene group correspond to "TSS1500" or "TSS200"
  \item promoter2: CpGs whose gene group correspond to "TSS1500", "TSS200", 
  "1stExon", or "5'UTR". 
}
If group = "all", all CpGs are considered regardless of their gene group.}

\item{method}{A string. "ORA" or "GSEA". Default is "ORA"}

\item{sig.cut}{A numeric value indicating FDR cut-off for significant gene
in ORA. Default is 0.05. This argument will be ignored if topDE is provided
or method = "GSEA" is used.}

\item{topDE}{An integer. The top number of genes to be declared as 
significant after robust rank aggregation. This argument will be ignored
if method = "GSEA" is used.}

\item{GS.list}{A list. Default is NULL. If there is no input list,
Gene Ontology is used. Entry names are gene sets names, and elements
correpond to genes that gene sets contain.}

\item{GS.idtype}{A string. "SYMBOL", "ENSEMBL", "ENTREZID" or
"REFSEQ". Default is "SYMBOL".}

\item{GS.type}{A string. "GO", "KEGG", or "Reactome". Default is "GO"}

\item{minsize}{An integer. If the number of genes in a gene set is
less than this integer, this gene set is not tested. Default is 100.}

\item{maxsize}{An integer. If the number of genes in a gene set is
greater than this integer, this gene set is not tested. Default is 500.}
}
\value{
A data frame contains gene set tests results.
}
\description{
This function implements enrichment after adjusting
multiple p-values of each gene by Robust Rank Aggregation.
}
\examples{
data(CpG2Genetoy)
data(cpgtoy)
data(GSlisttoy)
GS.list = GS.list[1:10]
FullAnnot = prepareAnnot(CpG2Gene)
res1 = methylRRA(cpg.pval = cpg.pval, FullAnnot = FullAnnot,
method = "ORA", GS.list = GS.list)
head(res1)
}
\references{
Kolde, Raivo, et al. Robust rank aggregation for gene
list integration and meta-analysis. Bioinformatics 28.4 (2012): 573-580.

Phipson, B., Maksimovic, J., and Oshlack, A. (2015).
missMethyl: an R package for analysing methylation data from Illuminas
HumanMethylation450 platform. Bioinformatics, btv560.

Yu, Guangchuang, et al. clusterProfiler: an R package for
comparing biological themes among gene clusters. Omics: a journal of
integrative biology 16.5 (2012): 284-287.

Carlson M (2017). org.Hs.eg.db: Genome wide annotation for
Human. R package version 3.5.0.
}
