% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{estBetaBeta}
\alias{estBetaBeta}
\title{Estimate the beta parameter of a beta distribution}
\usage{
estBetaBeta(meanCtrl, varCtrl, minVal = 1e-06)
}
\arguments{
\item{meanCtrl}{a \code{double}, the mean of the controls (CTRL) at a 
specific CpG site.}

\item{varCtrl}{a \code{double}, the variance of the controls (CTRL) at a 
specific CpG site.}

\item{minVal}{a \code{double}, the minimum value accepted for the mean
value. If \code{meanCtrl} is smaller than 
\code{minVal}, then \code{minVal} is used in the calculation of the beta
paramter. 
Default: \code{1e-06}.}
}
\value{
a \code{double}, the beta parameter of a Beta distribution.
}
\description{
Estimate the beta parameter from the mean and the variance
of a beta distribution.
}
\examples{

## Estimate beta parameters with mean = 0.5, variance = 0.1
methInheritSim:::estBetaBeta(meanCtrl=0.5, varCtrl=0.1)

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
