% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustData.R
\name{opts.duplicate}
\alias{opts.duplicate}
\title{Duplicate Feature Detection Parameters}
\usage{
opts.duplicate(
  mz = 0.0025,
  rt = 0.05,
  resolve = c("single", "merge"),
  weighted = FALSE
)
}
\arguments{
\item{mz}{m/z tolerance for duplicate feature detection}

\item{rt}{RT tolerance for duplicate feature}

\item{resolve}{character. Either "single" (default) or "merge".}

\item{weighted}{logical. Option to weight m/z, RT, Q by mean abundance of
each row (TRUE) or take single representative values (FALSE).}
}
\description{
Lists the parameters for detection of two or more rows that
represent the same entity, based on similar m/z and retention time values.
}
\details{
The presence of duplicate features has negative consequences for the LC-MS
alignment task. The package offers several options for resolving the issue
of feature duplication. Pairwise m/z and RT tolerances define which features
are to be considered as duplicates within a single data set. Setting
\code{mz} or \code{rt} to 0 skips duplicate feature filtering altogether.

When duplicates are detected, either a single master copy is retained
(\code{resolve} = "single") or merged into a single row
(\code{resolve} = "merge").The master copy is the copy with lower proportion
of missingness, followed by the most abundant (by median or mean). If %
missingness and abundance is equivalent for duplicates, the first copy that
appears is retained. The "merge" option fuses duplicate feature rows, with
quantitative descriptors (m/z, RT) either calculated as a weighted average
(\code{weighted} = TRUE) or otherwise taken from the top representative row;
id and adduct values are concatenated; the maximum feature value is used for
each sample; and all 'extra' values are taken from the 'master copy' row,
similar to the "single" option.
}
\examples{
data(plasma20)
pars.duplicate <- opts.duplicate(mz = 0.01, rt = 0.05, resolve = "single")
p20 <- metabData(plasma20, samples = "Red", duplicate = pars.duplicate)

#to prevent removal of duplicate features
p20 <- metabData(plasma20, samples = "Red", duplicate = opts.duplicate(0))

##merge option
pars.duplicate <- opts.duplicate(mz = 0.01, rt = 0.05, resolve = "merge")
p20 <- metabData(plasma20, samples = "Red", duplicate = pars.duplicate)


}
