% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{metabCombiner-class}
\alias{metabCombiner-class}
\title{'metabCombiner' Combined Metabolomics Dataset Class}
\description{
This is the main object for the \code{metabCombiner} package workflow. This
object holds a combined feature table, along with a retention time warping
model, the ordered pair anchors used to generate this model, important
information organized by dataset, and key object statistics.
}
\section{Slots}{

\describe{
\item{\code{combinedTable}}{data frame displaying all feature pair alignments,
combining measurements of all possible shared compounds}

\item{\code{featData}}{data frame of feature metadata (id, m/z, rt, Q, adduct)}

\item{\code{anchors}}{data frame of feature pairs used for RT warping model}

\item{\code{model}}{list containing the last fitted nonlinear model(s)}

\item{\code{datasets}}{list of constituent datasets from xdata & ydata inputs}

\item{\code{xy}}{current X & Y datasets}

\item{\code{nonmatched}}{list of data frames consisting of nonmatched features}

\item{\code{coefficients}}{list of last used A,B,C similarity weight values}

\item{\code{samples}}{list of sample name vectors from input datasets}

\item{\code{extra}}{list of extra column name vectors from input datasets}

\item{\code{stats}}{set of useful metabCombiner statistics}
}}

