% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{fitgamParam}
\alias{fitgamParam}
\title{List fit_gam Defaults}
\usage{
fitgamParam(
  useID = FALSE,
  k = seq(10, 20, 2),
  iterFilter = 2,
  outlier = "MAD",
  coef = 2,
  prop = 0.5,
  weights = 1,
  bs = "bs",
  family = "scat",
  m = c(3, 2),
  method = "REML",
  rtx = c("min", "max"),
  rty = c("min", "max"),
  optimizer = "newton",
  message = TRUE
)
}
\arguments{
\item{useID}{choice of preserving identity-based anchors; default: FALSE}

\item{k}{values for GAM basis dimension k}

\item{iterFilter}{number of outlier filtering iterations; default: 2}

\item{outlier}{outlier filtering method (either "MAD" (mean absolute
deviation) or "boxplot"); default: "MAD"}

\item{coef}{outlier filtering coefficient; default: 2}

\item{prop}{minimum proportion of fits in which a point can be a flagged
outlier; default: 0.5}

\item{weights}{optional supplied weights to individual points; default: 1}

\item{bs}{choice of spline type ("bs" or "ps"); default: "bs"}

\item{family}{choice of family ("scat" or "gaussian"); default: "scat"}

\item{m}{basis and penalty order; default: c(3,2)}

\item{method}{smoothing parameter estimation method; default: "REML"}

\item{rtx}{ordered pair of endpoints for rtx; default: ("min", "max")}

\item{rty}{ordered pair of endpoints for rty; default: ("min", "max")}

\item{optimizer}{numerical optimization for GAM; default: "newton"}

\item{message}{option to print progress message; default: TRUE}
}
\value{
list of fit_gam parameters
}
\description{
List of default parameters for GAM fitting step of main package workflow,
which can be used as input for the wrapper functions. See help(fit_gam)
or ?fit_gam for more details.
}
\examples{
fitParam <- fitgamParam(k = c(12,14,18,20), iterFilter = 1, bs = "ps",
                        family = "gaussian", method = "GCV.Cp")

}
\seealso{
\code{\link{fit_gam}}, \code{\link{metabCombine}}
}
