% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichMeSH.R
\name{enrichMeSH}
\alias{enrichMeSH}
\title{enrichMeSH}
\usage{
enrichMeSH(
  gene,
  MeSHDb,
  database = "gendoo",
  category = "C",
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe = NULL,
  minGSSize = 10,
  maxGSSize = 500,
  qvalueCutoff = 0.2,
  meshdbVersion = NULL
)
}
\arguments{
\item{gene}{a vector of entrez gene id}

\item{MeSHDb}{MeSHDb}

\item{database}{one of 'gendoo', 'gene2pubmed' or 'RBBH'}

\item{category}{one of "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L","M", "N", "V", "Z"}

\item{pvalueCutoff}{Cutoff value of pvalue.}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{universe}{background genes}

\item{minGSSize}{minimal size of genes annotated by Ontology term for testing.}

\item{maxGSSize}{maximal size of genes annotated for testing}

\item{qvalueCutoff}{qvalue cutoff}

\item{meshdbVersion}{version of MeSH.db. If NULL(the default), use the latest version.}
}
\value{
An \code{enrichResult} instance.
}
\description{
MeSH term enrichment analysis
}
\examples{
\dontrun{
library(meshes)
library(AnnotationHub)
ah <- AnnotationHub()
qr_hsa <- query(ah, c("MeSHDb", "Homo sapiens"))
filepath_hsa <- qr_hsa[[1]]
db <- MeSHDbi::MeSHDb(filepath_hsa)
data(geneList, package="DOSE")
de <- names(geneList)[1:100]
x <- enrichMeSH(de, MeSHDb = db, database='gendoo', category = 'C')
}
}
\seealso{
\code{class?enrichResult}
}
\author{
Guangchuang Yu
}
