% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_duplicate_motifs.R
\name{remove_duplicate_motifs}
\alias{remove_duplicate_motifs}
\title{Remove duplicated motif entries}
\usage{
remove_duplicate_motifs(x)
}
\arguments{
\item{x}{a universalmotif list or universalmotif_df}
}
\value{
A deduplicated list or universalmotif_df
}
\description{
This function identifies motif matrices which are duplicated in a
universalmotif list or universalmotif_df and removes them. This operation
ignores motif metadata and operates by removing all entries whose motif
matrices are identical. The first instance of a duplicated motif in the input
list is the one returned.
}
\examples{
motif <- universalmotif::create_motif()
duplicated <- c(motif, motif)
remove_duplicate_motifs(duplicated)
}
