% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ame.R
\name{importAme}
\alias{importAme}
\title{Parse AME output}
\usage{
importAme(
  path,
  method = c("fisher", "ranksum", "dmhg3", "dmhg4", "pearson", "spearman"),
  sequences = NULL
)
}
\arguments{
\item{path}{path to ame results file ("ame.tsv")}

\item{method}{ame run method used (one of: c("fisher", "ranksum", "dmhg3",
"dmhg4", "pearson", "spearman")). Default: "fisher".}

\item{sequences}{NULL/FALSE to skip sequence import, or path to sequences
file to import (only valid for method = "fisher")}
}
\value{
data.frame with method-specific results. See [AME
  results](http://meme-suite.org/doc/ame-output-format.html) webpage for more
  information. If sequences is set to a path to the sequences.tsv and method
  = "fisher", the list-column `sequences` will be appended to resulting
  data.frame.
}
\description{
This imports AME results using the "ame.tsv" output, and optionally the
"sequences.tsv" output if run with "method = fisher". AME results differ
based on the method used, thus this must be set on import or the column
names will be incorrect.
}
\examples{
ame_tsv <- system.file("extdata", "ame.tsv", package = "memes", mustWork = TRUE)
importAme(ame_tsv)
}
\seealso{
[runAme()]
}
\concept{import}
