% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/sig_gseaplot-methods.R
\name{sig_gseaplot}
\alias{sig_gseaplot}
\alias{sig_gseaplot,MArrayLM,vector-method}
\alias{sig_gseaplot,MArrayLM,list-method}
\alias{sig_gseaplot,DGEList,ANY-method}
\alias{sig_gseaplot,ANY,ANY-method}
\alias{sig_gseaplot,list,ANY-method}
\title{Visualize GSEA result with input list of gene symbols.}
\usage{
sig_gseaplot(
  data,
  sigs,
  group_col,
  target_group,
  gene_id = "SYMBOL",
  slot = "counts",
  method = c("dotplot", "gseaplot"),
  col = "-log10(p.adjust)",
  size = "enrichmentScore",
  pvalue_table = FALSE,
  digits = 2,
  rank_stat = "logFC",
  ...
)

\S4method{sig_gseaplot}{MArrayLM,vector}(
  data,
  sigs,
  group_col,
  target_group,
  gene_id = "SYMBOL",
  slot = "counts",
  method = c("dotplot", "gseaplot"),
  col = "-log10(p.adjust)",
  size = "enrichmentScore",
  pvalue_table = FALSE,
  digits = 2,
  rank_stat = "logFC",
  ...
)

\S4method{sig_gseaplot}{MArrayLM,list}(
  data,
  sigs,
  group_col,
  target_group,
  gene_id = "SYMBOL",
  slot = "counts",
  method = c("dotplot", "gseaplot"),
  col = "-log10(p.adjust)",
  size = "enrichmentScore",
  pvalue_table = FALSE,
  digits = 2,
  rank_stat = "logFC",
  ...
)

\S4method{sig_gseaplot}{DGEList,ANY}(
  data,
  sigs,
  group_col,
  target_group,
  gene_id = "SYMBOL",
  slot = "counts",
  method = c("dotplot", "gseaplot"),
  col = "-log10(p.adjust)",
  size = "enrichmentScore",
  pvalue_table = FALSE,
  digits = 2,
  rank_stat = "logFC",
  ...
)

\S4method{sig_gseaplot}{ANY,ANY}(
  data,
  sigs,
  group_col,
  target_group,
  gene_id = "SYMBOL",
  slot = "counts",
  method = c("dotplot", "gseaplot"),
  col = "-log10(p.adjust)",
  size = "enrichmentScore",
  pvalue_table = FALSE,
  digits = 2,
  rank_stat = "logFC",
  ...
)

\S4method{sig_gseaplot}{list,ANY}(
  data,
  sigs,
  group_col,
  target_group,
  gene_id = "SYMBOL",
  slot = "counts",
  method = c("dotplot", "gseaplot"),
  col = "-log10(p.adjust)",
  size = "enrichmentScore",
  pvalue_table = FALSE,
  digits = 2,
  rank_stat = "logFC",
  ...
)
}
\arguments{
\item{data}{expression data, can be matrix, DGEList, eSet, seurat, sce...}

\item{sigs}{a vector of signature (Symbols) or a list of signatures}

\item{group_col}{character or vector, specify the column name to compare in coldata}

\item{target_group}{pattern, specify the group of interest as reference}

\item{gene_id}{character, indicate the ID type of rowname of expression data's ,
could be one of 'ENSEMBL', 'SYMBOL', ... default 'SYMBOL'}

\item{slot}{character, indicate which slot used as expression, optional}

\item{method}{one of "gseaplot" and "dotplot", how to plot GSEA result}

\item{col}{column name of \code{\link[clusterProfiler:GSEA]{clusterProfiler::GSEA()}} result, used for dot
col when method = "dotplot"}

\item{size}{column name of \code{\link[clusterProfiler:GSEA]{clusterProfiler::GSEA()}} result, used for dot
size when method = "dotplot"}

\item{pvalue_table}{logical, if to add p value table if method = "gseaplot"}

\item{digits}{num, specify the number of significant digits of pvalue table}

\item{rank_stat}{character, specify which metric used to rank for GSEA,
default "logFC"}

\item{...}{params for function \code{\link[=get_de_table]{get_de_table()}} and function \code{\link[enrichplot:gseaplot2]{enrichplot::gseaplot2()}}}
}
\value{
patchwork object for all comparisons
}
\description{
Visualize GSEA result with multiple lists of genes by using \code{clusterProfiler}.
}
\examples{
data("im_data_6", "nk_markers")
sig_gseaplot(
  sigs = list(
    A = nk_markers$HGNC_Symbol[1:15],
    B = nk_markers$HGNC_Symbol[20:40],
    C = nk_markers$HGNC_Symbol[60:75]
  ),
  data = im_data_6, group_col = "celltype:ch1",
  target_group = "NK", gene_id = "ENSEMBL"
)

}
