% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/get_gsc_sig-methods.R
\name{get_gsc_sig}
\alias{get_gsc_sig}
\alias{get_gsc_sig,GeneSetCollection,character-method}
\alias{get_gsc_sig,character,character-method}
\title{Collect genes from MSigDB or provided GeneSetCollection.}
\usage{
get_gsc_sig(
  gsc = "msigdb",
  pattern,
  cat = NULL,
  subcat = NULL,
  species = c("hs", "mm"),
  id = c("SYM", "EZID"),
  version = msigdb::getMsigdbVersions(),
  ...
)

\S4method{get_gsc_sig}{GeneSetCollection,character}(
  gsc = "msigdb",
  pattern,
  cat = NULL,
  subcat = NULL,
  species = c("hs", "mm"),
  id = c("SYM", "EZID"),
  version = msigdb::getMsigdbVersions(),
  ...
)

\S4method{get_gsc_sig}{character,character}(
  gsc = "msigdb",
  pattern,
  cat = NULL,
  subcat = NULL,
  species = c("hs", "mm"),
  id = c("SYM", "EZID"),
  version = msigdb::getMsigdbVersions(),
  ...
)
}
\arguments{
\item{gsc}{'msigdb' or GeneSetCollection to be searched}

\item{pattern}{pattern pass to \code{\link[=grep]{grep()}}, to match the MsigDB gene-set name of
interest, e.g. 'NATURAL_KILLER_CELL_MEDIATED'}

\item{cat}{character, stating the category(s) to be retrieved.
The category(s) must be one from \code{\link[msigdb:listCollections]{msigdb::listCollections()}},
see details in \code{\link[msigdb:subsetCollection]{msigdb::subsetCollection()}}}

\item{subcat}{character, stating the sub-category(s) to be retrieved.
The sub-category(s) must be one from
\code{\link[msigdb:listSubCollections]{msigdb::listSubCollections()}}, see details in
\code{\link[msigdb:subsetCollection]{msigdb::subsetCollection()}}}

\item{species}{character, species of interest, can be 'hs' or 'mm'}

\item{id}{a character, representing the ID type to use ("SYM" for gene
SYMBOLs and "EZID" for ENTREZ IDs)}

\item{version}{a character, stating the version of MSigDB to be retrieved
(should be >= 7.2). See \code{\link[msigdb:getMsigdbVersions]{msigdb::getMsigdbVersions()}}.}

\item{...}{params for \code{\link[=grep]{grep()}}, used to match pattern to gene-set names}
}
\value{
A GeneSet object containing all matched gene-sets in MSigDB
}
\description{
Collect gene sets from MSigDB or given GeneSetCollection, of which the gene-set
names are matched to the given regex pattern by using \code{\link[=grep]{grep()}} function.
By setting cat and subcat, matching can be constrained in the union of given
categories and subcategories if gsc = 'msigdb'.
}
\examples{
data("msigdb_gobp_nk")
get_gsc_sig(
  gsc = msigdb_gobp_nk,
  pattern = "natural_killer_cell_mediated",
  subcat = "GO:BP",
  ignore.case = TRUE
)
}
