% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/get_de_table-methods.R
\name{get_de_table}
\alias{get_de_table}
\alias{get_de_table,DGEList,character,character-method}
\alias{get_de_table,matrix,vector,character-method}
\alias{get_de_table,Matrix,vector,character-method}
\alias{get_de_table,ExpressionSet,character,character-method}
\alias{get_de_table,SummarizedExperiment,character,character-method}
\alias{get_de_table,Seurat,character,character-method}
\title{Get DE analysis result table(s) with statistics}
\usage{
get_de_table(data, group_col, target_group, slot = "counts", ...)

\S4method{get_de_table}{DGEList,character,character}(data, group_col, target_group, slot = "counts", ...)

\S4method{get_de_table}{matrix,vector,character}(data, group_col, target_group, slot = "counts", ...)

\S4method{get_de_table}{Matrix,vector,character}(data, group_col, target_group, slot = "counts", ...)

\S4method{get_de_table}{ExpressionSet,character,character}(data, group_col, target_group, slot = "counts", ...)

\S4method{get_de_table}{SummarizedExperiment,character,character}(data, group_col, target_group, slot = "counts", ...)

\S4method{get_de_table}{Seurat,character,character}(data, group_col, target_group, slot = "counts", ...)
}
\arguments{
\item{data}{expression object}

\item{group_col}{vector or character, specify the group factor or column name of
coldata for DE comparisons}

\item{target_group}{pattern, specify the group of interest, e.g. NK}

\item{slot}{character, specify which slot to use only for DGEList, sce or
seurat object, optional, default 'counts'}

\item{...}{params for function \code{\link[=de_analysis]{de_analysis()}}}
}
\value{
A list of DE result table of all comparisons.
}
\description{
This function uses edgeR and limma to get DE analysis results
lists for multiple comparisons. Filter out low expressed genes and obtain
DE statistics by using limma::voom and limma::treat, and also create an
object \code{proc_data} to store processed data.
}
\examples{
data("im_data_6")
DE_tables <- get_de_table(im_data_6, group_col = "celltype:ch1", target_group = "NK")

}
