% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/sig_scatter_plot-methods.R
\name{sig_scatter_plot}
\alias{sig_scatter_plot}
\alias{sig_scatter_plot,matrix,vector,vector,character-method}
\alias{sig_scatter_plot,Matrix,vector,vector,character-method}
\alias{sig_scatter_plot,DGEList,vector,character,character-method}
\alias{sig_scatter_plot,ExpressionSet,vector,character,character-method}
\alias{sig_scatter_plot,Seurat,vector,character,character-method}
\alias{sig_scatter_plot,SummarizedExperiment,vector,character,character-method}
\alias{sig_scatter_plot,list,vector,character,character-method}
\title{Scatter plot of signature for specific subset vs others}
\usage{
sig_scatter_plot(
  data,
  sigs,
  group_col,
  target_group,
  slot = "counts",
  xint = 1,
  yint = 1,
  gene_id = "SYMBOL"
)

\S4method{sig_scatter_plot}{matrix,vector,vector,character}(
  data,
  sigs,
  group_col,
  target_group,
  xint = 1,
  yint = 1,
  gene_id = "SYMBOL"
)

\S4method{sig_scatter_plot}{Matrix,vector,vector,character}(
  data,
  sigs,
  group_col,
  target_group,
  xint = 1,
  yint = 1,
  gene_id = "SYMBOL"
)

\S4method{sig_scatter_plot}{DGEList,vector,character,character}(
  data,
  sigs,
  group_col,
  target_group,
  slot = "counts",
  xint = 1,
  yint = 1,
  gene_id = "SYMBOL"
)

\S4method{sig_scatter_plot}{ExpressionSet,vector,character,character}(
  data,
  sigs,
  group_col,
  target_group,
  xint = 1,
  yint = 1,
  gene_id = "SYMBOL"
)

\S4method{sig_scatter_plot}{Seurat,vector,character,character}(
  data,
  sigs,
  group_col,
  target_group,
  slot = "counts",
  xint = 1,
  yint = 1,
  gene_id = "SYMBOL"
)

\S4method{sig_scatter_plot}{SummarizedExperiment,vector,character,character}(
  data,
  sigs,
  group_col,
  target_group,
  slot = "counts",
  xint = 1,
  yint = 1,
  gene_id = "SYMBOL"
)

\S4method{sig_scatter_plot}{list,vector,character,character}(
  data,
  sigs,
  group_col,
  target_group,
  slot = "counts",
  xint = 1,
  yint = 1,
  gene_id = "SYMBOL"
)
}
\arguments{
\item{data}{expression data, can be matrix, DGEList, eSet, seurat, sce...}

\item{sigs}{a vector of signature (Symbols)}

\item{group_col}{character or vector, specify the column name to compare in coldata}

\item{target_group}{pattern, specify the group of interest as reference}

\item{slot}{character, indicate which slot used as expression, optional}

\item{xint}{intercept of vertical dashed line, default 1}

\item{yint}{intercept of horizontal dashed line, default 1}

\item{gene_id}{character, indicate the ID type of rowname of expression data's ,
could be one of 'ENSEMBL', 'SYMBOL', ... default 'SYMBOL'}
}
\value{
patchwork or ggplot of scatter plot of median expression
}
\description{
Scatter plot depicts mean expression for each signature gene in
the specific subset against other cell types.
}
\examples{
data("im_data_6", "nk_markers")
sig_scatter_plot(
  sigs = nk_markers$HGNC_Symbol, data = im_data_6,
  group_col = "celltype:ch1", target_group = "NK",
  gene_id = "ENSEMBL"
)

}
