% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/filter_subset_sig-methods.R
\name{filter_subset_sig}
\alias{filter_subset_sig}
\alias{filter_subset_sig,list-method}
\alias{filter_subset_sig,DGEList-method}
\alias{filter_subset_sig,ANY-method}
\title{Filter specific cell type signature genes against other subsets.}
\usage{
filter_subset_sig(
  data,
  group_col,
  target_group,
  markers = NULL,
  normalize = TRUE,
  dir = "UP",
  gene_id = "SYMBOL",
  feature_selection = c("auto", "rankproduct", "none"),
  comb = union,
  filter = c(10, 10),
  s_thres = 0.05,
  ...
)

\S4method{filter_subset_sig}{list}(
  data,
  group_col,
  target_group,
  markers = NULL,
  normalize = TRUE,
  dir = "UP",
  gene_id = "SYMBOL",
  feature_selection = c("auto", "rankproduct", "none"),
  comb = union,
  filter = c(10, 10),
  s_thres = 0.05,
  slot = "counts",
  batch = NULL,
  ...
)

\S4method{filter_subset_sig}{DGEList}(
  data,
  group_col,
  target_group,
  markers = NULL,
  normalize = TRUE,
  dir = "UP",
  gene_id = "SYMBOL",
  feature_selection = c("auto", "rankproduct", "none"),
  comb = union,
  filter = c(10, 10),
  s_thres = 0.05,
  ...
)

\S4method{filter_subset_sig}{ANY}(
  data,
  group_col,
  target_group,
  markers = NULL,
  normalize = TRUE,
  dir = "UP",
  gene_id = "SYMBOL",
  feature_selection = c("auto", "rankproduct", "none"),
  comb = union,
  filter = c(10, 10),
  s_thres = 0.05,
  ...
)
}
\arguments{
\item{data}{An expression data or a list of expression data objects}

\item{group_col}{vector or character, specify the group factor or column name of
coldata for DE comparisons}

\item{target_group}{pattern, specify the group of interest, e.g. NK}

\item{markers}{vector, a vector of gene names, listed the gene symbols to be
kept anyway after filtration. Default 'NULL' means no special
genes need to be kept.}

\item{normalize}{logical, if the expr in data is raw counts needs to be normalized}

\item{dir}{character, could be 'UP' or 'DOWN' to use only up- or
down-expressed genes}

\item{gene_id}{character, specify the gene ID target_group of rownames of expression data
when markers is not NULL, could be one of 'ENSEMBL', 'SYMBOL',
'ENTREZ'..., default 'SYMBOL'}

\item{feature_selection}{one of "auto" (default), "rankproduct" or "none",
choose if to use rank product or not to select DEGs
from multiple comparisons of DE analysis, 'auto'
uses 'rankproduct' but change to 'none' if final
genes < 5 for both UP and DOWN}

\item{comb}{'RRA' or Fun for combining sigs from multiple datasets, keep all
passing genes or only intersected genes, could be \code{union} or
\code{intersect} or \code{setdiff} or customized Fun, or could be 'RRA' to
use Robust Rank Aggregation method for integrating multi-lists
of sigs, default 'union'}

\item{filter}{(list of) vector of 2 numbers, filter condition to remove low
expression genes, the 1st for min.counts (if normalize = TRUE)
or CPM/TPM (if normalize = FALSE), the 2nd for samples size 'large.n'}

\item{s_thres}{num, threshold of score if comb = 'RRA'}

\item{...}{other params for \code{\link[=get_degs]{get_degs()}}}

\item{slot}{character, specify which slot to use only for DGEList, sce or
seurat object, optional, default 'counts'}

\item{batch}{vector of character, column name(s) of coldata to be treated as
batch effect factor, default NULL}
}
\value{
a vector of gene symbols
}
\description{
Specify the signature of the subset matched 'target_group' against other subsets,
either "union", "intersect" or "RRA" can be specified when input is a list
of datasets to integrate the signatures into one.
}
\examples{
data("im_data_6", "nk_markers")
sigs <- filter_subset_sig(im_data_6, "celltype:ch1", "NK",
  markers = nk_markers$HGNC_Symbol,
  gene_id = "ENSEMBL"
)

}
