% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{subnet}
\alias{subnet}
\title{Subgraph of vertices with an attribute}
\usage{
subnet(net, attr, values, affirmative = TRUE)
}
\arguments{
\item{net}{An igraph network.}

\item{attr}{An attribute of the vertices.}

\item{values}{Possible values of \code{attr}.}

\item{affirmative}{Logical. States if a condition must be its affirmation 
(e.g. all nodes with gene name "X"), or its negation (all nodes not with gene
name "X").}
}
\value{
A subgraph containing only the vertices with attribute equal to any
of the values in \code{values}.
}
\description{
Returns a subgraph matching some condition.
}
\examples{
gi <- get_GI_network(minigwas, snpMapping = minisnpMapping, ppi = minippi)
martini:::subnet(gi, "gene", "A")
martini:::subnet(gi, "name", c("1A1", "1A3"))
}
\keyword{internal}
