% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_causal_snps}
\alias{simulate_causal_snps}
\title{Simulate causal SNPs}
\usage{
simulate_causal_snps(net, ngenes = 20, pcausal = 1)
}
\arguments{
\item{net}{An igraph gene-interaction (GI) network that connects the SNPs.}

\item{ngenes}{Number of causal genes.}

\item{pcausal}{Number between 0 and 1, proportion of the SNPs in causal genes
that are causal themselves.}
}
\value{
A vector with the ids of the simulated causal SNPs.
}
\description{
Selects randomly interconnected genes as causal, then selects a
proportion of them as causal.
}
\examples{
gi <- get_GI_network(minigwas, snpMapping = minisnpMapping, ppi = minippi)
simulate_causal_snps(gi, ngenes=2)
}
