% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ld.R
\name{ldweight_edges}
\alias{ldweight_edges}
\title{Include linkage disequilibrium information in the network.}
\usage{
ldweight_edges(net, ld, method = "inverse")
}
\arguments{
\item{net}{A SNP network.}

\item{ld}{A \code{dsCMatrix} or \code{dgCMatrix} containing linkage 
disequilibrium measures, like the output of \code{\link[snpStats]{ld}}.}

\item{method}{How to incorporate linkage-disequilibrium values into the 
network.}
}
\value{
An copy of net where the edges weighted according to linkage 
disequilibrium.
}
\description{
Include linkage disequilibrium information in the SNP network. 
The weight of the edges will be lower the higher the linkage is.
}
\examples{
ld <- snpStats::ld(minigwas[['genotypes']], depth = 2, stats = "R.squared")
# don't weight edges for which LD cannot be calculated
ld[is.na(ld)] <- 0
gi <- get_GI_network(minigwas, snpMapping = minisnpMapping, ppi = minippi)
ldGi <- ldweight_edges(gi, ld)
}
