# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Maxflow algorithm
#' 
#' @description Run the maxflow algorithm.
#' @param A A sparse matrix with the connectivity.
#' @param As A vector containing the edges to the source.
#' @param At A vector containing the edges to the sink.
#' @return A list with vector indicating if the feature was selected and the 
#' objective score.
maxflow <- function(A, As, At) {
    .Call('_martini_maxflow', PACKAGE = 'martini', A, As, At)
}

#' Min-cut algorithm
#' 
#' @description Run the mincut algorithm.
#' @param c A vector with the association of each SNP with the phenotype.
#' @param eta A numeric with the value of the eta parameter.
#' @param lambda A numeric with the value of the eta parameter.
#' @param W A sparse matrix with the connectivity.
#' @return A list with vector indicating if the feature was selected and the 
#' objective score.
mincut_c <- function(c, eta, lambda, W) {
    .Call('_martini_mincut_c', PACKAGE = 'martini', c, eta, lambda, W)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_martini_RcppExport_registerCCallable', PACKAGE = 'martini')
})
