\name{maImage.func}
\alias{maImage.func}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{Color image for cDNA microarray spot statistics}
\description{
This function creates spatial images of shades of gray or colors that correspond to the values of a statistic for each spot on the array. The statistic can be the intensity log-ratio M, a spot quality measure (e.g. spot size or shape), or a test statistic. This function can be used to explore whether there are any spatial effects in the data, for example, print-tip or cover-slip effects. This function is called by \code{\link{maImage}}.
}

\usage{
maImage.func(x, L, subset=TRUE, col=heat.colors(12), contours=FALSE, overlay=NULL, ol.col=1,  ...)
}
%- maybe also `usage' for other objects documented here.

\arguments{
  \item{x}{A "numeric" vector of spot statistics.}
  \item{L}{An object of class \code{"\link{marrayLayout}"}, if L is
    missing we will assume the dimension of x.}
  \item{subset}{A "logical" or "numeric" vector indicating the subset of spots to display on the image.}
  \item{col}{A list of colors such as that generated by rainbow, heat.colors, topo.colors, terrain.colors, or similar functions. In addition to these color palette functions, a new function  \code{\link{maPalette}} was defined to generate color palettes from user supplied low, middle, and high color values.}
  \item{contours}{If \code{contours=TRUE}, contours are plotted,
    otherwise they are not shown.}
  \item{overlay}{A logical vector of spots to be highlighted on the image plots.}
  \item{ol.col}{Color of the overlay spots.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}

\references{S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}


\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}.}

\seealso{\code{\link{image}}, \code{\link{maImage}}, \code{\link{maColorBar}}, \code{\link{maPalette}}.}

\examples{
# See examples for image.
}
\keyword{hplot}% at least one, from doc/KEYWORDS

