% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllslotAccessors.R
\docType{methods}
\name{MarrSamplepairs}
\alias{MarrSamplepairs}
\alias{MarrSamplepairs,Marr-method}
\title{Generic function that returns the Marr sample pairs}
\usage{
MarrSamplepairs(object)

\S4method{MarrSamplepairs}{Marr}(object)
}
\arguments{
\item{object}{an object of class \code{Marr}.}
}
\value{
The distribution of percent reproducible features
(column-wise) per sample pair after applying the maximum
rank reproducibility.
}
\description{
Given a Marr object, this function returns the
Marr sample pairs

Accessors for the 'MarrSamplepairs' slot of
a Marr object.
}
\examples{
data <- matrix(rnorm(2400), nrow=200, ncol=12)
data_Marr <- Marr(object = data, pSamplepairs=0.75,
                  pFeatures=0.75, alpha=0.05)
MarrSamplepairs(data_Marr)

}
