% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-snapToBins.R
\name{snapToBins}
\alias{snapToBins}
\alias{snapToBins,GRanges,numeric-method}
\alias{snapToBins,GInteractions,numeric-method}
\title{Snap GRanges or GInteractions to nearest bins}
\usage{
snapToBins(x, binSize)

\S4method{snapToBins}{GRanges,numeric}(x, binSize)

\S4method{snapToBins}{GInteractions,numeric}(x, binSize)
}
\arguments{
\item{x}{`GInteractions` object.}

\item{binSize}{Integer (numeric) describing
the new size of each range.}
}
\value{
GRanges object snapped to the nearest `binSize`.

Input object snapped to the nearest `binSize`.
}
\description{
Snap GRanges or GInteractions to nearest bins

Snap paired-objects to nearest bins
}
\examples{
library(GenomicRanges)
## Example GRanges object
x <- GRanges(seqnames = c("chr1"),
             ranges = IRanges(start = c(1, 1, 25, 19, 21),
                              end = c(15, 11, 31, 31, 39)))

snapToBins(x, binSize = 5)
snapToBins(x, binSize = 10)
snapToBins(x, binSize = 20)

library(InteractionSet)
## Sample GInteractions object
x <- GInteractions(anchor1 = c(GRanges("chr1:1-15"),
                               GRanges("chr1:1-11")),
                   anchor2 = c(GRanges("chr1:25-31"),
                               GRanges("chr1:19-31")))

snapToBins(x, binSize = 5)
snapToBins(x, binSize = 10)
snapToBins(x, binSize = 20)

}
