% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R,
%   R/methods-makeRandomGInteractions.R
\name{makeRandomGRanges}
\alias{makeRandomGRanges}
\alias{makeRandomGInteractions}
\alias{makeRandomGRanges,Seqinfo-method}
\alias{makeRandomGInteractions,Seqinfo-method}
\title{Creating random GRanges & GInteractions}
\usage{
makeRandomGRanges(seqinfo, n = 100, ...)

makeRandomGInteractions(seqinfo, n = 100, interchromosomal = TRUE, ...)

\S4method{makeRandomGRanges}{Seqinfo}(seqinfo, n, .rows = NULL)

\S4method{makeRandomGInteractions}{Seqinfo}(seqinfo, n, interchromosomal)
}
\arguments{
\item{seqinfo}{A Seqinfo object containing the
chromosome names, lengths, and genome build.}

\item{n}{Integer describing the number of
random sequences to generate}

\item{...}{Additional arguments.}

\item{interchromosomal}{Boolean (TRUE/FALSE) indicating
whether interchromosomal interactions should be allowed.
Default is TRUE.}

\item{.rows}{(internal use only) vector of row positions
to sample from seqinfo.}
}
\value{
A GRanges or GInteractions object with ranges
 selected randomly with replacement on the provided
 seqinfo.
}
\description{
Creating random GRanges & GInteractions
}
\examples{
## Define Seqinfo containing chromosome info
if (require(TxDb.Hsapiens.UCSC.hg38.knownGene)) {
    txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene
    si <- seqinfo(txdb)
    si <- GenomeInfoDb::keepStandardChromosomes(si)
} else {
    si <- Seqinfo(
        seqnames=c("chr1", "chr2"),
        seqlengths=rep(200e6, 2),
        genome="hg38"
    )
}

## Make some GRanges
set.seed(123)
makeRandomGRanges(si, 100)

## Make some GInteractions
set.seed(123)
makeRandomGInteractions(si, n=100)

## Make some GInteractions only on same chromosome
set.seed(123)
makeRandomGInteractions(si, n=100, interchromosomal=FALSE)

## Use specific binSizes
n <- 100
binOptions <- seq(5e3, 200e3, by=5e3)
si <- Seqinfo(seqnames="chr1", seqlengths=200e6, genome="hg38")
set.seed(123)
bins <- sample(binOptions, n, replace=TRUE)
makeRandomGInteractions(si, n) |>
    resize(bins) |>
    trim()

}
