% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-MergedGInteractions.R
\name{clusters}
\alias{clusters}
\alias{clusters,MergedGInteractions-method}
\title{Get clustered pairs from MergedGInteractions object}
\usage{
clusters(x, ...)

\S4method{clusters}{MergedGInteractions}(x)
}
\arguments{
\item{x}{MergedGInteractions object.}

\item{...}{Additional arguments.}
}
\value{
A list of data.tables cooresponding to each pair
 in `x`.
}
\description{
Returns the clustered pairs associated with each
range in the `MergedGInteractions` object. Order always
follows the indices of the `MergedGInteractions`
object.
}
\examples{
## Load required packages
library(data.table, include.only="fread")

## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Reference BEDPE files (loops called with SIP)
bedpeFiles <- c(
    marinerData::FS_5kbLoops.txt(),
    marinerData::WT_5kbLoops.txt()
)
names(bedpeFiles) <- c("FS", "WT")

## Read in bedpeFiles as a list of GInteractions
## Use only first 1000 rows for fast example
giList <-
    lapply(bedpeFiles, fread, nrows = 1000) |>
    lapply(as_ginteractions)

## Cluster & merge pairs
x <- mergePairs(x = giList,
                radius = 10e03,
                column = "APScoreAvg")

## Access pair clusters
clusters(x[1:3])
clusters(x[3:1])
clusters(x[c(3, 1, 2)])
clusters(x) |> length()

}
