% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-aggHicMatrices.R
\name{aggHicMatrices}
\alias{aggHicMatrices}
\alias{aggHicMatrices,InteractionArray-method}
\title{Aggregate count matrices from
InteractionArray objects}
\usage{
aggHicMatrices(
  x,
  by = NULL,
  FUN = sum,
  nBlocks = 5,
  verbose = TRUE,
  BPPARAM = bpparam(),
  compressionLevel = 0
)

\S4method{aggHicMatrices}{InteractionArray}(
  x,
  by = NULL,
  FUN = sum,
  nBlocks = 5,
  verbose = TRUE,
  BPPARAM = bpparam(),
  compressionLevel = 0
)
}
\arguments{
\item{x}{InteractionArray object.}

\item{by}{String (length one character vector)
describing whether to aggregate by interactions,
files, or neither (i.e. NULL as default).}

\item{FUN}{Function to use for aggregating.}

\item{nBlocks}{Number of blocks for block-processing
arrays. Default is 5. Increase this for large
datasets. To read and process all data at once, set
this value to 1.}

\item{verbose}{Boolean (TRUE or FALSE) describing
whether to report block-processing progress.}

\item{BPPARAM}{Parallelization params (passed to
`BiocParallel::bplapply()`). Default is the result
of `BiocParallel::bpparams()`. Parallel processing
is not available when `by=interactions`.}

\item{compressionLevel}{Number (length one numeric vector)
between 0 (Default) and 9 indicating the compression
level used on HDF5 file.}
}
\value{
An aggregated `DelayedArray` object.
 If `by=interactions` or `by=files` then a 3-dimensional
 `DelayedArray` is returned. If `by=NULL` (default) then
 A 2-dimensional `DelayedMatrix` is returned.
}
\description{
Aggregation of count matrices is done
blocks to avoid large memory usage. Use
`nBlocks` to control the number of blocks
read into memory at once. Blocks are defined
as `length(interactions(x))/nBlocks`.
}
\details{
Since interactions are typically the largest
dimension in an InteractionArray, using
`by=interactions` creates an HDF5-backed array
to store these large arrays. Currently parallel
processing for HDF5-backed arrays are not
supported regardless of the value of `BPPARAM`.

Both `by=NULL` and `by=files` support parallel
processing.
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

## Read in loops as GInteractions object
loops <-
    WT_5kbLoops.txt() |>
    setNames("WT") |>
    read.table(header=TRUE) |>
    as_ginteractions(keep.extra.columns=FALSE)

## Removes the "chr" prefix for compatibility
## with the preprocessed hic files
GenomeInfoDb::seqlevelsStyle(loops) <- 'ENSEMBL'

## Expand pixel ranges with a 5 pixel buffer on either side
loops <-
    assignToBins(loops, binSize=100e3) |>
    pixelsToMatrices(buffer=5)

## Extract 10, 11x11 count matrices from 2 hic files
iarr <-
    loops[1:10] |>
    pullHicMatrices(binSize=100e3,
                    files=hicFiles)

## Aggregate all, by files, or by interactions
aggHicMatrices(x=iarr)
aggHicMatrices(x=iarr, by="files")
aggHicMatrices(x=iarr, by="interactions")

}
