% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-MergedGInteractions.R
\name{sets}
\alias{sets}
\alias{sets,MergedGInteractions,missing,missing-method}
\alias{sets,MergedGInteractions,character_OR_missing,missing-method}
\alias{sets,MergedGInteractions,missing,character_OR_missing-method}
\alias{sets,MergedGInteractions,character_OR_missing,character_OR_missing-method}
\title{Get each set from a MergedGInteractions object}
\usage{
sets(x, include, exclude)

\S4method{sets}{MergedGInteractions,missing,missing}(x)

\S4method{sets}{MergedGInteractions,character_OR_missing,missing}(x, include)

\S4method{sets}{MergedGInteractions,missing,character_OR_missing}(x, exclude)

\S4method{sets}{MergedGInteractions,character_OR_missing,character_OR_missing}(x, include, exclude)
}
\arguments{
\item{x}{MergedGInteractions object.}

\item{include}{(Optional) A character vector of sources
in which a pair must be present. For a list of available
sources use `sources(x)`.}

\item{exclude}{(Optional) A character vector of sources
in which a pair must be absent. For a list of available
sources use `sources(x)`.}
}
\value{
A list of subsetted `MergedGInteractions` objects
 or a `MergedGInteractions` object (if `include` and/or
 `exclude` are used).
}
\description{
Returns the subset of MergedGInteractions that belong
to each input source object (see these with `sources(x)`).
If the source pairs all come from the same object, their
corresponding merged pair is returned. However, if at least
one source pair comes from a different object, then that
merged pair is not returned.
}
\details{
Optional `include` and `exclude` parameters modulate
the behavior of `sets` to return different
subsets of originating pairs. For example, `include` requires
that the returned pairs be present in specific sources,
while `exclude` requires that returned pairs be absent
from specific sources. Sources not listed in either
`include` or `exclude` are ignored (they may or may not)
be present in the returned `MergedGInteractions` object.
`include` and `exclude` can be used indepedently or in
combination to return every possible set. If any of the
same sources are used in both `include` and `exclude` the
function will return a 0-length MergedGInteractions object.
}
\examples{
## Load required packages
library(GenomicRanges)
library(InteractionSet)

## Define example anchor regions
gr1 <-
    GRanges(seqnames = "chr1",
            ranges = IRanges(start = c(30,40,40,70,80),
                             end = c(40,50,50,80,90)))
gr2 <-
    GRanges(seqnames = "chr1",
            ranges = IRanges(start = c(30,30,50,10,30),
                             end = c(40,40,60,20,40)))

## Form GInteractions and split into two files
giList <- split(x = GInteractions(gr1, gr2),
                f = c(rep(1,3), rep(2,2)))

## Merge pairs
x <- mergePairs(x = giList, radius = 20)

sets(x)

}
