% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_identification.R
\name{find_ppi_v}
\alias{find_ppi_v}
\title{Find V motifs in protein-protein interactions}
\usage{
find_ppi_v(edgelist = NULL, paralogs = NULL, count_only = FALSE)
}
\arguments{
\item{edgelist}{A 2-column data frame with protein 1 in column 1 and
protein 2 in column 2.}

\item{paralogs}{A 2-column data frame with gene IDs for each paralog
in the paralog pair.}

\item{count_only}{Logical indicating whether the function should return
only motif counts as a numeric scalar. If FALSE, it will return
a character vector of motifs. Default: FALSE.}
}
\value{
A character vector with V motifs represented
in the format \strong{paralog1-partner-paralog2}.
}
\description{
Find V motifs in protein-protein interactions
}
\details{
This function aims to find the number of paralogous gene
pairs that share an interaction partner.
}
\examples{
data(gma_ppi)
data(gma_paralogs)
edgelist <- gma_ppi
paralogs <- gma_paralogs[gma_paralogs$type == "WGD", 1:2]
motifs <- find_ppi_v(edgelist, paralogs)
}
