% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepAscat.R
\name{prepAscat}
\alias{prepAscat}
\title{Prepare input files for ASCAT}
\usage{
prepAscat(
  t_counts = NULL,
  n_counts = NULL,
  sample_name = NA,
  min_depth = 15,
  normalize = TRUE
)
}
\arguments{
\item{t_counts}{read counts from tumor generated by \code{\link{gtMarkers}}}

\item{n_counts}{read counts from normal generated by \code{\link{gtMarkers}}}

\item{sample_name}{Sample name. Used as a basename for output files. Default `NA`, parses from `t_counts` file.}

\item{min_depth}{Min read depth required to consider a marker. Default 15}

\item{normalize}{If TRUE, normalizes for library size. Default TRUE}
}
\description{
Function takes the output from \code{\link{gtMarkers}} and generates `logR` and `BAF` files required for ASCAT analysis.
}
\details{
The function will filter SNPs with low coverage (default <15), estimate BAF, logR, and generates the input files for ASCAT. Alternatively, logR file can be segmented with \code{\link{segmentLogR}}
}
\references{
Van Loo P, Nordgard SH, Lingjærde OC, et al. Allele-specific copy number analysis of tumors. Proc Natl Acad Sci U S A. 2010;107(39):16910-16915. doi:10.1073/pnas.1009843107
}
\seealso{
\code{\link{gtMarkers}} \code{\link{prepAscat_t}} \code{\link{segmentLogR}}
}
