% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTiTv.R
\name{plotTiTv}
\alias{plotTiTv}
\title{Plot Transition and Trasnversion ratios.}
\usage{
plotTiTv(
  res = NULL,
  plotType = "both",
  sampleOrder = NULL,
  color = NULL,
  showBarcodes = FALSE,
  textSize = 0.8,
  baseFontSize = 1,
  axisTextSize = c(1, 1),
  plotNotch = FALSE
)
}
\arguments{
\item{res}{results generated by \code{\link{titv}}}

\item{plotType}{Can be 'bar', 'box' or 'both'. Defaults to 'both'}

\item{sampleOrder}{Sample names in which the barplot should be ordered. Default NULL}

\item{color}{named vector of colors for each coversion class.}

\item{showBarcodes}{Whether to include sample names for barplot}

\item{textSize}{fontsize if showBarcodes is TRUE. Deafult 2.}

\item{baseFontSize}{font size. Deafult 1.}

\item{axisTextSize}{text size x and y tick labels. Default c(1,1).}

\item{plotNotch}{logical. Include notch in boxplot.}
}
\value{
None.
}
\description{
Takes results generated from \code{titv} and plots the Ti/Tv ratios and contributions of 6 mutational conversion classes in each sample.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
laml.titv = titv(maf = laml, useSyn = TRUE)
plotTiTv(laml.titv)

}
\seealso{
\code{\link{titv}}
}
