% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntcounts.R
\name{bamreadcounts}
\alias{bamreadcounts}
\title{extract nucleotide counts for targeted variants from the BAM file.}
\usage{
bamreadcounts(
  bam = NULL,
  loci = NULL,
  zerobased = FALSE,
  mapq = 10,
  sam_flag = 1024,
  op = NULL,
  fa = NULL,
  nthreads = 4
)
}
\arguments{
\item{bam}{Input bam file(s). Required.}

\item{loci}{Loci file. Can be a tsv file or a data.frame. First two columns should contain chromosome and position (by default assumes coordinates are 1-based)}

\item{zerobased}{are coordinates zero-based. Default FALSE.}

\item{mapq}{Map quality. Default 10}

\item{sam_flag}{SAM FLAG to filter reads. Default 1024}

\item{op}{Output file basename. Default parses from BAM file}

\item{fa}{Indexed fasta file. If provided, extracts and adds reference base to the output tsv.}

\item{nthreads}{Number of threads to use. Each BAM file will be launched on a separate thread. Works only on Unix and macOS.}
}
\description{
Given a BAM file and target loci, `bamreadcounts` fetches redcounts for A, T, G, C, Ins, and Del. Function name is an homage to https://github.com/genome/bam-readcount
}
