% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_pqn}
\alias{normalize_pqn}
\title{Perform Probabilistic Quotient Normalization for intensities.}
\usage{
normalize_pqn(data, measure = "Area", exclude = "blank", log = TRUE)
}
\arguments{
\item{data}{LipidomicsExperiment object.}

\item{measure}{Which measure to use as intensity, usually Area,
Area Normalized or Height. Default is \code{Area}.}

\item{exclude}{Samples to exclude, can be either: \cr
"blank" - automatically detected blank samples and exclude them
logical vector with the same length as samples. Default.}

\item{log}{Whether the normalized values should be log2 transformed. Default
is \code{TRUE}.}
}
\value{
A LipidomicsExperiment object with normalized values
}
\description{
Perform Probabilistic Quotient Normalization (PQN) for sample intensities.
The PQN method determines a dilution factor for each sample by comparing
the distribution of quotients between samples and a reference spectrum,
followed by sample normalization using this dilution factor.
The reference spectrum in this method is the average lipid abundance of all
samples (excluding blanks).
}
\examples{
datadir <- system.file("extdata", package = "lipidr")
filelist <- list.files(datadir, "data.csv", full.names = TRUE)
d <- read_skyline(filelist)
clinical_file <- system.file("extdata", "clin.csv", package = "lipidr")
d <- add_sample_annotation(d, clinical_file)
d_summarized <- summarize_transitions(d, method = "average")

# Normalize data that have been summarized (single value per molecule).
data_normalized <- normalize_pqn(
  d_summarized,
  measure = "Area", exclude = "blank", log = TRUE
)
}
\references{
Dieterle, F., Ross, A., Schlotterbeck, G., & Senn, H. (2006).
Probabilistic quotient normalization as robust method to account for dilution
of complex biological mixtures. Application in 1H NMR metabonomics.
Analytical chemistry, 78(13), 4281-4290.
}
