% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lipidr-package.R
\docType{package}
\name{lipidr-package}
\alias{lipidr-package}
\alias{lipidr}
\title{Analysis workflow for targeted lipidomics}
\description{
\code{lipidr} implements a series of functions to facilitate inspection,
analysis and visualization of targeted lipidomics datasets. \code{lipidr}
takes exported Skyline CSV as input, allowing for multiple methods to
be analyzed together.
}
\details{
\code{lipidr} represents Skyline files as SummarizedExperiment objects, which can
easily be integrated with a wide variety of Bioconductor packages.
Sample annotations,
such as sample group or other clinical information can be loaded. \code{lipidr}
generates various plots, such as PCA score plots and box plots, for quality
control of samples and measured lipids. Normalization methods with and
without internal standards are also supported.

Differential analysis can be performed using any of the loaded clinical
variables, which can be readily visualized as volcano plots. A novel lipid
set enrichment analysis (LSEA) is implemented to detect preferential
enrichment of certain lipid classes, total chain lengths or unsaturation
patterns. Plots for the visualization of enrichment results are also
implemented.
}
\author{
Ahmed Mohamed \email{ahmed.mohamed@qimrberghofer.edu.au}
}
\keyword{internal}
