% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{annotate_lipids}
\alias{annotate_lipids}
\title{Parse molecule names to extract lipid class and chain information.}
\usage{
annotate_lipids(molecules, no_match = c("warn", "remove", "ignore"))
}
\arguments{
\item{molecules}{A character vector containing lipid molecule names.}

\item{no_match}{How to handle lipids that cannot be parsed? Default is
to give warnings.}
}
\value{
A data.frame with lipid annotations as columns. Input lipid names
are given in a column named "Molecule".
}
\description{
Parse lipid names to return a data.frame containing lipid class,
total chain length and unsaturation. Lipids should follow the pattern
'class xx:x/yy:y', with class referring to the abbreviated lipid class,
xx:x as the composition of the first chain and yy:y as the second chain.
Alternatively, lipids can be supplied following the pattern 'class zz:z',
where zz:z indicates the combined chain length and unsaturation information.
}
\examples{
lipid_list <- c(
  "Lyso PE 18:1(d7)",
  "PE(32:0)",
  "Cer(d18:0/C22:0)",
  "TG(16:0/18:1/18:1)"
)
annotate_lipids(lipid_list)
}
