% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readfiles.R
\name{add_sample_annotation}
\alias{add_sample_annotation}
\title{Add sample annotation to Skyline data frame}
\usage{
add_sample_annotation(data, annot_file)
}
\arguments{
\item{data}{LipidomicsExperiment object.}

\item{annot_file}{CSV file or a data.frame with at least 2 columns,
sample names & group(s).}
}
\value{
LipidomicsExperiment with sample group information.
}
\description{
Add sample annotation to Skyline data frame
}
\examples{
datadir <- system.file("extdata", package = "lipidr")

# all csv files
filelist <- list.files(datadir, "data.csv", full.names = TRUE)
d <- read_skyline(filelist)

# Add clinical info to existing LipidomicsExperiment object
clinical_file <- system.file("extdata", "clin.csv", package = "lipidr")
d <- add_sample_annotation(d, clinical_file)
colData(d)
d$group

# Subset samples using clinical information
# Note we are subsetting columns
d[, d$group == "QC"]

# Subset lipids using lipid annotation
# Note we are subsetting rows
d[rowData(d)$istd, ]
}
