% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpModelMatrix.R
\name{lmpModelMatrix}
\alias{lmpModelMatrix}
\title{Creates the model matrix \code{X}}
\usage{
lmpModelMatrix(lmpDataList)
}
\arguments{
\item{lmpDataList}{A list containing the outcomes, the experimental design and the formula.}
}
\value{
A list with the 5 following named elements :
\describe{
\item{\code{lmpDataList}}{The initial object: a list with outcomes, design and formula, as outputted by \code{\link{data2LmpDataList}}.}
\item{\code{modelMatrix}}{A \emph{nxK} model matrix specifically encoded for the ASCA-GLM method.}
\item{\code{modelMatrixByEffect}}{A list of \emph{p} model matrices for each model effect.}
\item{\code{effectsNamesUnique}}{A character vector with the \emph{p} names of the model effects, each repeated once.}
\item{\code{effectsNamesAll}}{A character vector with the \emph{K} names of the model effects ordered and repeated as the column names of the model matrix.}
}
}
\description{
Creates the model matrix \code{X} from the design matrix and the model formula.
}
\details{
In typical ASCA-GLM (ASCA+) analysis, the effects of the GLM model must first be used to transform the design matrix to a model matrix where the design factors encoded usign \emph{sum coding} commonly used in industrial experimental design.
Suppose the design matrix is \emph{nxk} with n observations and \emph{k} factors. After the transformation, the model matrix
will be of size \emph{nxp}. For a fator with \emph{a} levels, the \emph{sum coding} creates \emph{a-1} columns in the model matrix with 0 and 1 for the \emph{a-1} first levels and -1 for the last one.
\emph{p} is the total number parameter for each response (outcome) in the ASCA model.
More information is available in the article (\emph{Thiel et al}, 2017)
Note that at the moment, only factors can be used as explanatory variables.
}
\examples{

data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)

head(resLmpModelMatrix$modelMatrix)

}
\references{
Thiel M.,Feraud B. and Govaerts B. (2017) \emph{ASCA+ and APCA+: Extensions of ASCA and APCA
in the analysis of unbalanced multifactorial designs}, Journal of Chemometrics
}
\seealso{
\code{\link{model.matrix}}
}
