% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpBootstrapTests.R
\name{lmpBootstrapTests}
\alias{lmpBootstrapTests}
\title{Tests the significance of model effects by bootstrap.}
\usage{
lmpBootstrapTests(
  resLmpEffectMatrices,
  nboot = 100,
  nCores = 2,
  verbose = FALSE
)
}
\arguments{
\item{resLmpEffectMatrices}{A list of 12 from \code{\link{lmpEffectMatrices}}.}

\item{nboot}{An integer with the number of bootstrap sample to be drawn.}

\item{nCores}{The number of cores to use for parallel execution.}

\item{verbose}{If \code{TRUE}, will display a message with the duration of execution.}
}
\value{
A list with the following elements:
\describe{
\item{\code{f.obs}}{A vector of size F (number of effects in the model) with the F statistics for each model term calculated on the initial data.}
\item{\code{f.boot}}{ b × F matrix with the F statistics calculated on the bootstrap samples.}
\item{\code{p.values}}{A vector of size F with the p-value for each model effect.}
\item{\code{resultsTable}}{A 2 × F matrix with the p-value and the percentage of variance for each model effect.}
}
}
\description{
Tests the significance of the effects from the model using bootstrap. This function is based on the outputs of \code{\link{lmpEffectMatrices}}. Tests on combined effects are also provided.
}
\examples{
data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)
resLmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix = resLmpModelMatrix)

res <- lmpBootstrapTests(
  resLmpEffectMatrices = resLmpEffectMatrices,
  nboot = 10, nCores = 2, verbose = TRUE
)

}
\references{
Thiel M.,Feraud B. and Govaerts B. (2017) \emph{ASCA+ and APCA+: Extensions of ASCA and APCA
in the analysis of unbalanced multifactorial designs}, Journal of Chemometrics

Thiel, M., Benaiche, N., Martin, M., Franceschini, S., Van Oirbeek, R., & Govaerts, B. (2023)
\emph{limpca: an R package for the linear modeling of high dimensional designed data based on
ASCA/APCA family of methods}, Journal of Chemometrics
}
