% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sHWE.R
\name{sHWE}
\alias{sHWE}
\title{Hardy-Weinberg Equilibrium in structure populations}
\usage{
sHWE(X, LF, B, max_iter = 100, tol = 1e-10)
}
\arguments{
\item{X}{A matrix of SNP genotypes, i.e. an integer matrix of 0's,
1's, 2's and \code{NA}s.
BEDMatrix is supported.
Sparse matrices of class Matrix are not supported (yet).}

\item{LF}{matrix of logistic factors}

\item{B}{number of null datasets to generate, \code{B = 1} is usually
sufficient. If computational time/power allows, a few extra
\code{B} could be helpful}

\item{max_iter}{Maximum number of iterations for logistic regression}

\item{tol}{Tolerance value passed to \code{\link[=trunc_svd]{trunc_svd()}}
Ignored if \code{X} is a BEDMatrix object.}
}
\value{
a vector of p-values for each SNP.
}
\description{
Compute structural Hardy-Weinberg Equilibrium (sHWE) p-values
on a SNP-by-SNP basis. These p-values can be aggregated to
determine genome-wide goodness-of-fit for a particular value
of \code{d}. See \doi{10.1101/240804} for more
details.
}
\examples{
# get LFs
LF <- lfa(hgdp_subset, 4)
# look at a small (300) number of SNPs for rest of this example:
hgdp_subset_small <- hgdp_subset[ 1:300, ]
gof_4 <- sHWE(hgdp_subset_small, LF, 3)
LF <- lfa(hgdp_subset, 10)
gof_10 <- sHWE(hgdp_subset_small, LF, 3)
hist(gof_4)
hist(gof_10)
}
