% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levi.R
\name{levi}
\alias{levi}
\title{levi}
\usage{
levi(expressionInput, fileTypeInput, networkCoordinatesInput,
networkInteractionsInput, geneSymbolnput, readExpColumn,
contrastValueInput, zoomValueInput, resolutionValueInput,
smoothValueInput, expressionLog, contourLevi, setcolor)
}
\arguments{
\item{expressionInput}{Filename of gene expression data, which is a
numeric data.frame or matrix. The rows represent genes/proteins and the
columns represent the experiment (RNA-seq, microarray, etc).}

\item{fileTypeInput}{Filename of biological network. Levi can read files
written in the following formats: Medusa (DAT), RedeR (DYN), Pajek (NET)
and STRING/STITCH}

\item{networkCoordinatesInput}{It allows the user to load the coordinate
of the nodes the network.}

\item{networkInteractionsInput}{Parameter available only to
STRING/STITCH data format.
It allows the user to load the interaction data file of the network.}

\item{geneSymbolnput}{Column name from gene expression data containing the
identifier (gene Symbol, Entrez ID, EMSEMBL, etc).}

\item{readExpColumn}{Variable from readExpColumn function containing the
comparisons of the experiments}

\item{contrastValueInput}{Numeric value for image contrast. The variable
range is 0 to 100. The default value is 50}

\item{zoomValueInput}{Numeric value for image zoom. The variable range is 0
to 100. The default value is 50.}

\item{resolutionValueInput}{Numeric value for image resolution. The variable
range is 0 to 100. The default value is 50.}

\item{smoothValueInput}{Numeric value for image smoothness. The variable
range is 0 to 100. The default is 50.}

\item{expressionLog}{Logical variable to indicate Log2 normalization in the
expression levels. The default is FALSE}

\item{contourLevi}{Logical variable to allow contour lines. The default is
TRUE.}

\item{setcolor}{Select the color palette to build the heatmat. There is
two options the **Multicolor** has 20 color levels combined. The
**Two colors** has two types of color and the options available are: *purple_pink*,
*green_blue*, *blue_yellow*, *pink_green*, *orange_purple*, *green_marine*.}
}
\value{
Return a ggplot object and print a image (heatmat).
}
\description{
This is the Levi script mode. It allows you to create the
integration of networks and gene expression levels as batch
processing
}
\details{
Integrates the biological network and gene expression levels
(or other type of data)
}
\examples{
template_network <- file.path(system.file(package="levi"),"extdata",
   "medusa.dat", fsep = .Platform$file.sep)

template_expression <- file.path(system.file(package="levi"),
   "extdata","expression.dat", fsep = .Platform$file.sep)

multicolor <- levi(networkCoordinatesInput = template_network,
   expressionInput = template_expression, fileTypeInput = "dat",
   geneSymbolnput = "ID",
   readExpColumn=readExpColumn("TumorCurrentSmoker-NormalNeverSmoker"),
   contrastValueInput = 50, resolutionValueInput  = 50, zoomValueInput = 50,
   smoothValueInput = 50, expressionLog = FALSE, contourLevi = TRUE)

twocolors <- levi(networkCoordinatesInput = template_network,
   expressionInput = template_expression, fileTypeInput = "dat",
   geneSymbolnput = "ID",
   readExpColumn = readExpColumn("TumorCurrentSmoker-NormalNeverSmoker"),
   setcolor = "pink_green", contourLevi = FALSE)
}
\author{
Isabelle Mira da Silva (isabelle.silva@unesp.br), José Rafael Pilan (rafael.pilan@unesp.br)
}
