% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{residuals,lemur_fit-method}
\alias{residuals,lemur_fit-method}
\title{Predict values from \code{lemur_fit} object}
\usage{
\S4method{residuals}{lemur_fit}(object, with_linear_model = TRUE, with_embedding = TRUE, ...)
}
\arguments{
\item{object}{an \code{lemur_fit} object}

\item{with_linear_model}{a boolean to indicate if the linear regression
offset is included in the prediction.}

\item{with_embedding}{a boolean to indicate if the embedding contributes
to the output.}

\item{...}{ignored.}
}
\value{
A matrix with the same dimension \code{dim(object)}.
}
\description{
Predict values from \code{lemur_fit} object
}
\examples{
data(glioblastoma_example_data)
fit <- lemur(glioblastoma_example_data, design = ~ patient_id + condition,
             n_emb = 5, verbose = FALSE)

resid <- residuals(fit)
dim(resid)


}
\seealso{
\link{predict.lemur_fit}
}
