% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedToCg.R
\name{bedToCg}
\alias{bedToCg}
\title{Convert BED CpG set to YAME .cg format}
\usage{
bedToCg(bed_file, ref_cr, out_file, sort_bed = TRUE, verbose = FALSE)
}
\arguments{
\item{bed_file}{Character string. Path to BED file listing CpGs.}

\item{ref_cr}{Character string. Path to YAME reference coordinate file (.cr).}

\item{out_file}{Character string. Path to output .cg file.}

\item{sort_bed}{Logical. Whether to sort the BED file with bedtools before
intersecting. (Default: TRUE)}

\item{verbose}{Logical. Whether to print the shell commands. (Default: FALSE)}
}
\value{
Invisibly returns the output file path.
}
\description{
Converts a BED file listing CpGs into a YAME-compressed .cg file using
the YAME reference coordinate and command-line tools.
}
\examples{
# Download YAME reference coordinate file for mm10
ref_cr <- tempfile(fileext = ".cr")
download.file(
  "https://zenodo.org/records/18176270/files/mm10chr16_f7_cpg.cr",
  destfile = ref_cr, quiet = TRUE, mode = "wb"
)

# Create a BED file with CpG positions
bed_file <- tempfile(fileext = ".bed")
bed_data <- c(
    "chr16\t3003648\t3003650",
    "chr16\t3003766\t3003768",
    "chr16\t3004036\t3004038",
    "chr16\t3004052\t3004054",
    "chr16\t3004275\t3004277",
    "chr16\t3004470\t3004472",
    "chr16\t3004545\t3004547",
    "chr16\t3004633\t3004635",
    "chr16\t3004652\t3004654",
    "chr16\t3004739\t3004741",
    "chr16\t3004841\t3004843",
    "chr16\t3004959\t3004961",
    "chr16\t3005065\t3005067",
    "chr16\t3005444\t3005446",
    "chr16\t3005522\t3005524")

writeLines(bed_data, bed_file)

# Convert BED to YAME .cg format (requires bedtools and yame)
out_file <- tempfile(fileext = ".cg")
\donttest{
bedToCg(bed_file, ref_cr, out_file, verbose = TRUE)
}

# Clean up
unlink(c(bed_file, ref_cr, out_file))
}
