% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genes.R
\name{mergeTranscripts}
\alias{mergeTranscripts}
\title{mergeTranscripts}
\usage{
mergeTranscripts(genes.data)
}
\arguments{
\item{genes.data}{(GenesData object) A valid genes.dat object like the ones obtained by \code{\link{makeGenesDataFromTxDb}}}
}
\value{
The original GenesData object with a single transcript per gene 
\code{GenesData$genes$names}.
}
\description{
Merges the transcripts of each gene and creates one transcript per gene with
all exons and UTR regions combined
}
\details{
This function takes a valid data object and merges all transcripts from 
each gene into a single transcript. This is useful to reduce the plot
complexity while keeping partial information on transcript structure.#' 
In this transcript, any region that is a coding exon in any transcript,
will be an exon, any region that is a non-coding exon in any transcript
and is not an exon in any transcript, will be a non-coding exon. 
Anything between coding and non-coding exons will be introns.
}
\examples{
 
library(TxDb.Hsapiens.UCSC.hg19.knownGene)

zoom <- toGRanges("chr17:29.4e6-29.8e6")
kp <- plotKaryotype(genome="hg19", zoom=zoom)
genes.data <- makeGenesDataFromTxDb(TxDb.Hsapiens.UCSC.hg19.knownGene, karyoplot=kp)
genes.data <- addGeneNames(genes.data)
kpPlotGenes(kp, data=genes.data, r1=0.5, plot.transcripts=TRUE, gene.name.position = "left")
genes.data.merged <- mergeTranscripts(genes.data)
kpPlotGenes(kp, data=genes.data.merged, r0=0.6, r1=0.8, plot.transcripts=TRUE, gene.name.position = "left")
 
}
\seealso{
\code{\link{kpPlotGenes}}, \code{\link{makeGenesDataFromTxDb}}
}
